/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.completion;

import java.util.Collections;
import java.util.List;
import org.crsh.cli.completers.EmptyCompleter;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CommandCompletion;
import org.crsh.cli.impl.completion.Completion;
import org.crsh.cli.impl.completion.CompletionException;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.impl.completion.EmptyCompletion;
import org.crsh.cli.impl.completion.OptionCompletion;
import org.crsh.cli.impl.completion.ParameterCompletion;
import org.crsh.cli.impl.completion.SpaceCompletion;
import org.crsh.cli.impl.parser.Event;
import org.crsh.cli.impl.parser.Mode;
import org.crsh.cli.impl.parser.Parser;
import org.crsh.cli.impl.tokenizer.Token;
import org.crsh.cli.impl.tokenizer.TokenizerImpl;
import org.crsh.cli.spi.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompletionMatcher<T> {
    private final CommandDescriptor<T> descriptor;
    private final String mainName;

    public CompletionMatcher(CommandDescriptor<T> descriptor) {
        this(null, descriptor);
    }

    public CompletionMatcher(String mainName, CommandDescriptor<T> descriptor) {
        this.mainName = mainName;
        this.descriptor = descriptor;
    }

    public final CompletionMatch match(String s) throws CompletionException {
        return this.match(EmptyCompleter.getInstance(), s);
    }

    public CompletionMatch match(Completer completer, String s) throws CompletionException {
        return this.getCompletion(completer, s).complete();
    }

    private Completion argument(CommandDescriptor<?> method, Completer completer) {
        List<ArgumentDescriptor> arguments = method.getArguments();
        if (arguments.isEmpty()) {
            return new EmptyCompletion();
        }
        ArgumentDescriptor argument = arguments.get(0);
        return new ParameterCompletion("", Delimiter.EMPTY, argument, completer);
    }

    private Completion getCompletion(Completer completer, String s) throws CompletionException {
        Event event;
        CommandDescriptor<T> descriptor = this.descriptor;
        TokenizerImpl tokenizer = new TokenizerImpl(s);
        Parser<T> parser = new Parser<T>(tokenizer, descriptor, this.mainName, Mode.COMPLETE);
        Event last = null;
        Event.Separator separator = null;
        CommandDescriptor<Object> method = null;
        while (true) {
            if ((event = parser.next()) instanceof Event.Separator) {
                separator = (Event.Separator)event;
                continue;
            }
            if (event instanceof Event.Stop) break;
            if (event instanceof Event.Option) {
                last = event;
                separator = null;
                continue;
            }
            if (event instanceof Event.Subordinate) {
                method = ((Event.Subordinate)event).getDescriptor();
                last = event;
                separator = null;
                continue;
            }
            if (!(event instanceof Event.Argument)) continue;
            last = event;
            separator = null;
        }
        Event.Stop stop = (Event.Stop)event;
        if (stop instanceof Event.Stop.Unresolved.NoSuchOption) {
            Event.Stop.Unresolved.NoSuchOption nso = (Event.Stop.Unresolved.NoSuchOption)stop;
            return new OptionCompletion(method != null ? method : descriptor, (Token.Literal.Option)nso.getToken());
        }
        if (stop instanceof Event.Stop.Unresolved) {
            if (stop instanceof Event.Stop.Unresolved.TooManyArguments) {
                if (method == null) {
                    Event.Stop.Unresolved.TooManyArguments tma = (Event.Stop.Unresolved.TooManyArguments)stop;
                    return new CommandCompletion<T>(descriptor, this.mainName, s.substring(stop.getIndex()), parser.getDelimiter());
                }
                return new EmptyCompletion();
            }
            return new EmptyCompletion();
        }
        if (stop instanceof Event.Stop.Done) {
            // empty if block
        }
        if (last == null) {
            if (method == null) {
                if (((Object)descriptor.getSubordinates().keySet()).equals(Collections.singleton(this.mainName))) {
                    method = descriptor.getSubordinate(this.mainName);
                    List<ArgumentDescriptor> args = method.getArguments();
                    if (args.size() > 0) {
                        return new ParameterCompletion("", Delimiter.EMPTY, args.get(0), completer);
                    }
                    return new EmptyCompletion();
                }
                return new CommandCompletion<T>(descriptor, this.mainName, s.substring(stop.getIndex()), Delimiter.EMPTY);
            }
            return new EmptyCompletion();
        }
        if (last instanceof Event.Option) {
            Event.Option optionEvent = (Event.Option)last;
            List values = optionEvent.getValues();
            OptionDescriptor option = (OptionDescriptor)optionEvent.getParameter();
            if (separator == null) {
                if (values.size() == 0) {
                    return new SpaceCompletion();
                }
                if (values.size() <= option.getArity()) {
                    Token.Literal.Word word = (Token.Literal.Word)optionEvent.peekLast();
                    return new ParameterCompletion(word.getValue(), parser.getDelimiter(), option, completer);
                }
                return new EmptyCompletion();
            }
            if (values.size() < option.getArity()) {
                return new ParameterCompletion("", Delimiter.EMPTY, option, completer);
            }
            if (method == null) {
                return new CommandCompletion<T>(descriptor, this.mainName, s.substring(stop.getIndex()), Delimiter.EMPTY);
            }
            return this.argument(method, completer);
        }
        if (last instanceof Event.Argument) {
            Event.Argument eventArgument = (Event.Argument)last;
            ArgumentDescriptor argument = (ArgumentDescriptor)eventArgument.getParameter();
            if (separator != null) {
                switch (argument.getMultiplicity()) {
                    case SINGLE: {
                        List<ArgumentDescriptor> arguments = eventArgument.getCommand().getArguments();
                        int index = arguments.indexOf(argument) + 1;
                        if (index < arguments.size()) {
                            ArgumentDescriptor nextArg = arguments.get(index);
                            return new ParameterCompletion("", Delimiter.EMPTY, nextArg, completer);
                        }
                        return new EmptyCompletion();
                    }
                    case MULTI: {
                        return new ParameterCompletion("", Delimiter.EMPTY, argument, completer);
                    }
                }
                throw new AssertionError();
            }
            Object value = eventArgument.peekLast();
            return new ParameterCompletion(((Token.Literal)value).getValue(), parser.getDelimiter(), argument, completer);
        }
        if (last instanceof Event.Subordinate) {
            if (separator != null) {
                return this.argument(method, completer);
            }
            return new SpaceCompletion();
        }
        throw new AssertionError();
    }
}

