/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.groovy;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.crsh.cli.Argument;
import org.crsh.cli.Command;
import org.crsh.cli.Man;
import org.crsh.cli.Option;
import org.crsh.cli.Required;
import org.crsh.cli.Usage;
import org.crsh.command.CRaSHCommand;
import org.crsh.command.InvocationContext;
import org.crsh.command.ScriptException;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.Style;
import org.crsh.text.ui.BorderStyle;

@GroovyASTTransformation(phase=CompilePhase.CONVERSION)
public class DefaultImportTransformer
implements ASTTransformation {
    private static final Logger log = Logger.getLogger(DefaultImportTransformer.class.getName());
    private static final Class<?>[] defaultImports = new Class[]{Required.class, Man.class, Usage.class, Argument.class, Option.class, Command.class, ScriptException.class, InvocationContext.class, CRaSHCommand.class};
    private static final Class<?>[] defaultStaticImports = new Class[]{Color.class, Decoration.class, Style.class, BorderStyle.class};

    public void visit(ASTNode[] nodes, SourceUnit source) {
        log.log(Level.FINE, "Transforming source to add default import package");
        for (Class<?> defaultImport : defaultImports) {
            log.log(Level.FINE, "Adding default import for class " + defaultImport.getName());
            if (source.getAST().getImport(defaultImport.getSimpleName()) != null) continue;
            source.getAST().addImport(defaultImport.getSimpleName(), ClassHelper.make(defaultImport));
        }
        for (Class<?> defaultStaticImport : defaultStaticImports) {
            log.log(Level.FINE, "Adding default static import for class " + defaultStaticImport.getName());
            if (source.getAST().getStaticStarImports().containsKey(defaultStaticImport.getSimpleName())) continue;
            source.getAST().addStaticStarImport(defaultStaticImport.getSimpleName(), ClassHelper.make(defaultStaticImport));
        }
    }
}

