/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.remoting;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.remoting.ClientMessage;
import org.crsh.shell.impl.remoting.ClientProcessContext;
import org.crsh.shell.impl.remoting.ServerMessage;
import org.crsh.util.CloseableList;
import org.crsh.util.Statement;

public class ClientAutomaton
implements Runnable {
    final Shell shell;
    final ObjectOutputStream out;
    final ObjectInputStream in;
    ClientProcessContext current;
    final CloseableList listeners;
    Integer width;
    Integer height;
    long last;

    public ClientAutomaton(ObjectOutputStream out, ObjectInputStream in, Shell shell) {
        CloseableList listeners = new CloseableList();
        listeners.add(in);
        listeners.add(out);
        this.in = in;
        this.out = out;
        this.shell = shell;
        this.listeners = listeners;
        this.width = null;
        this.height = null;
    }

    public ClientAutomaton(InputStream in, OutputStream out, Shell shell) throws IOException {
        this(new ObjectOutputStream(out), new ObjectInputStream(in), shell);
    }

    public ClientAutomaton addCloseListener(Closeable closeable) {
        this.listeners.add(closeable);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.listeners.isClosed()) {
                ClientMessage msg = (ClientMessage)this.in.readObject();
                if (msg instanceof ClientMessage.GetWelcome) {
                    String welcome = this.shell.getWelcome();
                    this.out.writeObject(new ServerMessage.Welcome(welcome));
                    this.out.flush();
                    continue;
                }
                if (msg instanceof ClientMessage.GetPrompt) {
                    String prompt = this.shell.getPrompt();
                    this.out.writeObject(new ServerMessage.Prompt(prompt));
                    this.out.flush();
                    continue;
                }
                if (msg instanceof ClientMessage.GetCompletion) {
                    String prefix = ((ClientMessage.GetCompletion)msg).prefix;
                    CommandCompletion completion = this.shell.complete(prefix);
                    this.out.writeObject(new ServerMessage.Completion(completion));
                    this.out.flush();
                    continue;
                }
                if (msg instanceof ClientMessage.SetSize) {
                    ClientMessage.SetSize setSize = (ClientMessage.SetSize)msg;
                    this.width = setSize.width;
                    this.height = setSize.height;
                    this.last = System.currentTimeMillis();
                    continue;
                }
                if (msg instanceof ClientMessage.Execute) {
                    ClientMessage.Execute execute = (ClientMessage.Execute)msg;
                    this.width = execute.width;
                    this.height = execute.height;
                    this.last = System.currentTimeMillis();
                    this.current = new ClientProcessContext(this, this.shell.createProcess(execute.line));
                    this.current.execute();
                    continue;
                }
                if (msg instanceof ClientMessage.Cancel) {
                    if (this.current == null) continue;
                    final ClientProcessContext context = this.current;
                    Statement statements = new Statement(){

                        protected void run() throws Throwable {
                            context.end(ShellResponse.cancelled());
                        }
                    }.with(new Statement(){

                        protected void run() throws Throwable {
                            context.process.cancel();
                        }
                    });
                    statements.all();
                    continue;
                }
                if (!(msg instanceof ClientMessage.Close)) continue;
                this.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.close();
        }
    }

    void close() {
        this.listeners.close();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

