/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.remoting;

import java.io.IOException;
import java.util.ArrayList;
import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.remoting.ClientAutomaton;
import org.crsh.shell.impl.remoting.ServerMessage;
import org.crsh.text.Chunk;
import org.crsh.util.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientProcessContext
implements ShellProcessContext {
    final ClientAutomaton client;
    final ShellProcess process;
    final ArrayList<Chunk> buffer;

    ClientProcessContext(ClientAutomaton client, ShellProcess process) {
        this.client = client;
        this.process = process;
        this.buffer = new ArrayList(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSize() {
        if (System.currentTimeMillis() - this.client.last > 2000L) {
            ClientProcessContext clientProcessContext = this;
            synchronized (clientProcessContext) {
                try {
                    this.client.out.writeObject(new ServerMessage.GetSize());
                    this.client.out.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void execute() {
        try {
            this.process.execute(this);
        }
        catch (Throwable t) {
            new Statement(){

                protected void run() throws Throwable {
                    ClientProcessContext.this.end(ShellResponse.error(ErrorType.INTERNAL, "Unexpected process execution error", t));
                }
            }.all();
        }
    }

    @Override
    public int getWidth() {
        this.ensureSize();
        return this.client.getWidth();
    }

    @Override
    public int getHeight() {
        this.ensureSize();
        return this.client.getHeight();
    }

    @Override
    public boolean takeAlternateBuffer() {
        try {
            this.client.out.writeObject(new ServerMessage.UseAlternateBuffer());
            this.client.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean releaseAlternateBuffer() {
        try {
            this.client.out.writeObject(new ServerMessage.UseMainBuffer());
            this.client.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public String getProperty(String name) {
        return null;
    }

    @Override
    public String readLine(String msg, boolean echo) {
        return null;
    }

    @Override
    public void provide(Chunk element) throws IOException {
        this.buffer.add(element);
    }

    @Override
    public Class<Chunk> getConsumedType() {
        return Chunk.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() {
        if (this.buffer.size() > 0) {
            try {
                for (Chunk chunk : this.buffer) {
                    this.client.out.writeObject(new ServerMessage.Chunk(chunk));
                }
                this.client.out.writeObject(new ServerMessage.Flush());
                this.client.out.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                this.buffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void end(ShellResponse response) {
        if (this.client.current == this) {
            this.flush();
            try {
                this.client.current = null;
                this.client.out.writeObject(new ServerMessage.End(response));
                this.client.out.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                if (response instanceof ShellResponse.Close) {
                    this.client.close();
                }
            }
        }
    }
}

