/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.formatter;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.Renderable;
import org.crsh.text.Renderer;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.Overflow;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableElement;
import org.crsh.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadRenderable
extends Renderable<Thread> {
    private static final EnumMap<Thread.State, Color> colorMapping = new EnumMap(Thread.State.class);

    @Override
    public Class<Thread> getType() {
        return Thread.class;
    }

    @Override
    public Renderer renderer(Iterator<Thread> stream) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        List<Thread> threads = Utils.list(stream);
        HashMap<Long, Long> times1 = new HashMap<Long, Long>();
        for (Thread thread : threads) {
            long cpu = threadMXBean.getThreadCpuTime(thread.getId());
            times1.put(thread.getId(), cpu);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        HashMap<Long, Long> times2 = new HashMap<Long, Long>(threads.size());
        for (Thread thread : threads) {
            long cpu = threadMXBean.getThreadCpuTime(thread.getId());
            times2.put(thread.getId(), cpu);
        }
        long total = 0L;
        HashMap<Long, Long> deltas = new HashMap<Long, Long>(threads.size());
        for (Long id : times2.keySet()) {
            long time1 = (Long)times2.get(id);
            long time2 = (Long)times1.get(id);
            if (time1 == -1L) {
                time1 = time2;
            } else if (time2 == -1L) {
                time2 = time1;
            }
            long delta = time2 - time1;
            deltas.put(id, delta);
            total += delta;
        }
        final HashMap<Thread, Long> cpus = new HashMap<Thread, Long>(threads.size());
        for (Thread thread : threads) {
            long cpu = total == 0L ? 0L : (long)Math.round((Long)deltas.get(thread.getId()) * 100L / total);
            cpus.put(thread, cpu);
        }
        Collections.sort(threads, new Comparator<Thread>(){

            @Override
            public int compare(Thread o1, Thread o2) {
                long l2;
                long l1 = (Long)cpus.get(o1);
                if (l1 < (l2 = ((Long)cpus.get(o2)).longValue())) {
                    return 1;
                }
                if (l1 > l2) {
                    return -1;
                }
                return 0;
            }
        });
        TableElement table = new TableElement(1, 3, 2, 1, 1, 1, 1, 1, 1).overflow(Overflow.HIDDEN).rightCellPadding(1);
        RowElement header = new RowElement();
        header.style(Decoration.bold.fg(Color.black).bg(Color.white));
        header.add(new LabelElement("ID"));
        header.add(new LabelElement("NAME"));
        header.add(new LabelElement("GROUP"));
        header.add(new LabelElement("PRIORITY"));
        header.add(new LabelElement("STATE"));
        header.add(new LabelElement("%CPU"));
        header.add(new LabelElement("TIME"));
        header.add(new LabelElement("INTERRUPTED"));
        header.add(new LabelElement("DAEMON"));
        table.add(header);
        for (Thread thread : threads) {
            Color c = colorMapping.get((Object)thread.getState());
            long seconds = (Long)times2.get(thread.getId()) / 1000000000L;
            long min = seconds / 60L;
            String time = min + ":" + seconds % 60L;
            long cpu = (Long)cpus.get(thread);
            ThreadGroup group = thread.getThreadGroup();
            RowElement row = new RowElement();
            row.add(new LabelElement(thread.getId()));
            row.add(new LabelElement(thread.getName()));
            row.add(new LabelElement(group == null ? "" : group.getName()));
            row.add(new LabelElement(thread.getPriority()));
            row.add(new LabelElement((Object)thread.getState()).style(c.fg()));
            row.add(new LabelElement(cpu));
            row.add(new LabelElement(time));
            row.add(new LabelElement(thread.isInterrupted()));
            row.add(new LabelElement(thread.isDaemon()));
            table.add(row);
        }
        return table.renderer();
    }

    static {
        colorMapping.put(Thread.State.NEW, Color.cyan);
        colorMapping.put(Thread.State.RUNNABLE, Color.green);
        colorMapping.put(Thread.State.BLOCKED, Color.red);
        colorMapping.put(Thread.State.WAITING, Color.yellow);
        colorMapping.put(Thread.State.TIMED_WAITING, Color.magenta);
        colorMapping.put(Thread.State.TERMINATED, Color.blue);
    }
}

