/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import net.wimpi.telnetd.BootException;
import net.wimpi.telnetd.net.Connection;
import net.wimpi.telnetd.net.ConnectionData;
import net.wimpi.telnetd.net.ConnectionEvent;
import net.wimpi.telnetd.net.ConnectionFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager
implements Runnable {
    private static Log log = LogFactory.getLog(class$net$wimpi$telnetd$net$ConnectionManager == null ? (class$net$wimpi$telnetd$net$ConnectionManager = ConnectionManager.class$("net.wimpi.telnetd.net.ConnectionManager")) : class$net$wimpi$telnetd$net$ConnectionManager);
    private Thread m_Thread;
    private ThreadGroup m_ThreadGroup = new ThreadGroup(this.toString() + "Connections");
    private List m_OpenConnections;
    private Stack m_ClosedConnections = new Stack();
    private ConnectionFilter connectionFilter;
    private int maxConnections;
    private int warningTimeout;
    private int disconnectTimeout;
    private int housekeepingInterval;
    private String loginShell;
    private boolean lineMode = false;
    private boolean stopping = false;
    static /* synthetic */ Class class$net$wimpi$telnetd$net$ConnectionManager;

    public ConnectionManager() {
        this.m_OpenConnections = Collections.synchronizedList(new ArrayList(100));
    }

    public ConnectionManager(int con, int timew, int timedis, int hoke, ConnectionFilter filter, String lsh, boolean lm) {
        this();
        this.connectionFilter = filter;
        this.loginShell = lsh;
        this.lineMode = lm;
        this.maxConnections = con;
        this.warningTimeout = timew;
        this.disconnectTimeout = timedis;
        this.housekeepingInterval = hoke;
    }

    public void setConnectionFilter(ConnectionFilter filter) {
        this.connectionFilter = filter;
    }

    public ConnectionFilter getConnectionFilter() {
        return this.connectionFilter;
    }

    public int openConnectionCount() {
        return this.m_OpenConnections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(int idx) {
        List list = this.m_OpenConnections;
        synchronized (list) {
            return (Connection)this.m_OpenConnections.get(idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection[] getConnectionsByAdddress(InetAddress addr) {
        ArrayList<Connection> l = new ArrayList<Connection>();
        List list = this.m_OpenConnections;
        synchronized (list) {
            Iterator iterator = this.m_OpenConnections.iterator();
            while (iterator.hasNext()) {
                Connection connection = (Connection)iterator.next();
                if (!connection.getConnectionData().getInetAddress().equals(addr)) continue;
                l.add(connection);
            }
        }
        Connection[] conns = new Connection[l.size()];
        return l.toArray(conns);
    }

    public void start() {
        this.m_Thread = new Thread(this);
        this.m_Thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        log.debug("stop()::" + this.toString());
        this.stopping = true;
        try {
            if (this.m_Thread != null) {
                this.m_Thread.join();
            }
        }
        catch (InterruptedException iex) {
            log.error("stop()", iex);
        }
        List list = this.m_OpenConnections;
        synchronized (list) {
            Iterator iter = this.m_OpenConnections.iterator();
            while (iter.hasNext()) {
                try {
                    Connection tc = (Connection)iter.next();
                    tc.close();
                }
                catch (Exception exc) {
                    log.error("stop()", exc);
                }
            }
            this.m_OpenConnections.clear();
        }
        log.debug("stop():: Stopped " + this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeConnection(Socket insock) {
        log.debug("makeConnection()::" + insock.toString());
        if (this.connectionFilter == null || this.connectionFilter != null && this.connectionFilter.isAllowed(insock.getInetAddress())) {
            ConnectionData newCD = new ConnectionData(insock, this);
            newCD.setLoginShell(this.loginShell);
            newCD.setLineMode(this.lineMode);
            if (this.m_OpenConnections.size() < this.maxConnections) {
                Connection con = new Connection(this.m_ThreadGroup, newCD);
                Object[] args = new Object[]{new Integer(this.m_OpenConnections.size() + 1)};
                log.info(MessageFormat.format("connection #{0,number,integer} made.", args));
                List list = this.m_OpenConnections;
                synchronized (list) {
                    this.m_OpenConnections.add(con);
                }
                con.start();
            }
        } else {
            log.info("makeConnection():: Active Filter blocked incoming connection.");
            try {
                insock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void run() {
        try {
            do {
                this.cleanupClosed();
                this.checkOpenConnections();
                Thread.sleep(this.housekeepingInterval);
            } while (!this.stopping);
        }
        catch (Exception e) {
            log.error("run()", e);
        }
        log.debug("run():: Ran out " + this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupClosed() {
        if (this.stopping) {
            return;
        }
        while (!this.m_ClosedConnections.isEmpty()) {
            Connection nextOne = (Connection)this.m_ClosedConnections.pop();
            log.info("cleanupClosed():: Removing closed connection " + nextOne.toString());
            List list = this.m_OpenConnections;
            synchronized (list) {
                this.m_OpenConnections.remove(nextOne);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpenConnections() {
        if (this.stopping) {
            return;
        }
        List list = this.m_OpenConnections;
        synchronized (list) {
            Iterator iter = this.m_OpenConnections.iterator();
            while (iter.hasNext()) {
                Connection conn = (Connection)iter.next();
                ConnectionData cd = conn.getConnectionData();
                if (!conn.isActive()) {
                    this.registerClosedConnection(conn);
                    continue;
                }
                long inactivity = System.currentTimeMillis() - cd.getLastActivity();
                if (inactivity <= (long)this.warningTimeout) continue;
                if (inactivity > (long)(this.disconnectTimeout + this.warningTimeout)) {
                    log.debug("checkOpenConnections():" + conn.toString() + " exceeded total timeout.");
                    conn.processConnectionEvent(new ConnectionEvent(conn, 101));
                    continue;
                }
                if (cd.isWarned()) continue;
                log.debug("checkOpenConnections():" + conn.toString() + " exceeded warning timeout.");
                cd.setWarned(true);
                conn.processConnectionEvent(new ConnectionEvent(conn, 100));
            }
        }
    }

    public void registerClosedConnection(Connection con) {
        if (this.stopping) {
            return;
        }
        if (!this.m_ClosedConnections.contains(con)) {
            log.debug("registerClosedConnection()::" + con.toString());
            this.m_ClosedConnections.push(con);
        }
    }

    public static ConnectionManager createConnectionManager(String name, Properties settings) throws BootException {
        try {
            int maxc = Integer.parseInt(settings.getProperty(name + ".maxcon"));
            int timow = Integer.parseInt(settings.getProperty(name + ".time_to_warning"));
            int timodis = Integer.parseInt(settings.getProperty(name + ".time_to_timedout"));
            int hoke = Integer.parseInt(settings.getProperty(name + ".housekeepinginterval"));
            String filterclass = settings.getProperty(name + ".connectionfilter");
            ConnectionFilter filter = null;
            String loginshell = "";
            boolean linemode = false;
            if (filterclass != null && filterclass.length() != 0 && !filterclass.toLowerCase().equals("none")) {
                filter = (ConnectionFilter)Class.forName(filterclass).newInstance();
                filter.initialize(settings);
            }
            if ((loginshell = settings.getProperty(name + ".loginshell")) == null || loginshell.length() == 0) {
                log.error("Login shell not specified.");
                throw new BootException("Login shell must be specified.");
            }
            String inputmode = settings.getProperty(name + ".inputmode");
            if (inputmode == null || inputmode.length() == 0) {
                log.info("Input mode not specified using character input as default.");
                linemode = false;
            } else if (inputmode.toLowerCase().equals("line")) {
                linemode = true;
            }
            ConnectionManager cm = new ConnectionManager(maxc, timow, timodis, hoke, filter, loginshell, linemode);
            return cm;
        }
        catch (Exception ex) {
            log.error("createConnectionManager():", ex);
            throw new BootException("Failure while creating ConnectionManger instance:\n" + ex.getMessage());
        }
    }

    public int getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    public void setDisconnectTimeout(int disconnectTimeout) {
        this.disconnectTimeout = disconnectTimeout;
    }

    public int getHousekeepingInterval() {
        return this.housekeepingInterval;
    }

    public void setHousekeepingInterval(int housekeepingInterval) {
        this.housekeepingInterval = housekeepingInterval;
    }

    public boolean isLineMode() {
        return this.lineMode;
    }

    public void setLineMode(boolean lineMode) {
        this.lineMode = lineMode;
    }

    public String getLoginShell() {
        return this.loginShell;
    }

    public void setLoginShell(String loginShell) {
        this.loginShell = loginShell;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getWarningTimeout() {
        return this.warningTimeout;
    }

    public void setWarningTimeout(int warningTimeout) {
        this.warningTimeout = warningTimeout;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

