/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.LineReader;
import org.crsh.text.Renderer;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.LabelReader;
import org.crsh.util.Pair;

class LabelRenderer
extends Renderer {
    private final LabelElement element;

    LabelRenderer(LabelElement element) {
        this.element = element;
    }

    public int getMinWidth() {
        return this.element.minWidth;
    }

    public int getActualWidth() {
        return this.element.actualWidth;
    }

    public int getActualHeight(int width) {
        return this.element.slicer.lines(width).length;
    }

    public int getMinHeight(int width) {
        return this.getActualHeight(width);
    }

    public LineReader reader(int width) {
        return this.reader(width, -1);
    }

    public LineReader reader(int width, int height) {
        if (width == 0) {
            return null;
        }
        Pair<Integer, Integer>[] lines = this.element.slicer.lines(width);
        if (height == -1) {
            height = lines.length;
        }
        if (lines.length > height) {
            return null;
        }
        return new LabelReader(this.element, lines, width, height);
    }
}

