/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.MaxBytesExceededException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Strings;

public class Salsa20Engine
implements StreamCipher {
    private static final int stateSize = 16;
    private static final byte[] sigma = Strings.toByteArray("expand 32-byte k");
    private static final byte[] tau = Strings.toByteArray("expand 16-byte k");
    private int index = 0;
    private int[] engineState = new int[16];
    private int[] x = new int[16];
    private byte[] keyStream = new byte[64];
    private byte[] workingKey = null;
    private byte[] workingIV = null;
    private boolean initialised = false;
    private int cW0;
    private int cW1;
    private int cW2;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Salsa20 Init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        if (byArray == null || byArray.length != 8) {
            throw new IllegalArgumentException("Salsa20 requires exactly 8 bytes of IV");
        }
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("Salsa20 Init parameters must include a key");
        }
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.workingKey = keyParameter.getKey();
        this.workingIV = byArray;
        this.setKey(this.workingKey, this.workingIV);
    }

    @Override
    public String getAlgorithmName() {
        return "Salsa20";
    }

    @Override
    public byte returnByte(byte by) {
        if (this.limitExceeded()) {
            throw new MaxBytesExceededException("2^70 byte limit per IV; Change IV");
        }
        if (this.index == 0) {
            this.salsa20WordToByte(this.engineState, this.keyStream);
            this.engineState[8] = this.engineState[8] + 1;
            if (this.engineState[8] == 0) {
                this.engineState[9] = this.engineState[9] + 1;
            }
        }
        byte by2 = (byte)(this.keyStream[this.index] ^ by);
        this.index = this.index + 1 & 0x3F;
        return by2;
    }

    @Override
    public void processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + n2 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.limitExceeded(n2)) {
            throw new MaxBytesExceededException("2^70 byte limit per IV would be exceeded; Change IV");
        }
        for (int i = 0; i < n2; ++i) {
            if (this.index == 0) {
                this.salsa20WordToByte(this.engineState, this.keyStream);
                this.engineState[8] = this.engineState[8] + 1;
                if (this.engineState[8] == 0) {
                    this.engineState[9] = this.engineState[9] + 1;
                }
            }
            byArray2[i + n3] = (byte)(this.keyStream[this.index] ^ byArray[i + n]);
            this.index = this.index + 1 & 0x3F;
        }
    }

    @Override
    public void reset() {
        this.setKey(this.workingKey, this.workingIV);
    }

    private void setKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        this.workingKey = byArray;
        this.workingIV = byArray2;
        this.index = 0;
        this.resetCounter();
        int n = 0;
        this.engineState[1] = this.byteToIntLittle(this.workingKey, 0);
        this.engineState[2] = this.byteToIntLittle(this.workingKey, 4);
        this.engineState[3] = this.byteToIntLittle(this.workingKey, 8);
        this.engineState[4] = this.byteToIntLittle(this.workingKey, 12);
        if (this.workingKey.length == 32) {
            byArray3 = sigma;
            n = 16;
        } else {
            byArray3 = tau;
        }
        this.engineState[11] = this.byteToIntLittle(this.workingKey, n);
        this.engineState[12] = this.byteToIntLittle(this.workingKey, n + 4);
        this.engineState[13] = this.byteToIntLittle(this.workingKey, n + 8);
        this.engineState[14] = this.byteToIntLittle(this.workingKey, n + 12);
        this.engineState[0] = this.byteToIntLittle(byArray3, 0);
        this.engineState[5] = this.byteToIntLittle(byArray3, 4);
        this.engineState[10] = this.byteToIntLittle(byArray3, 8);
        this.engineState[15] = this.byteToIntLittle(byArray3, 12);
        this.engineState[6] = this.byteToIntLittle(this.workingIV, 0);
        this.engineState[7] = this.byteToIntLittle(this.workingIV, 4);
        this.engineState[9] = 0;
        this.engineState[8] = 0;
        this.initialised = true;
    }

    private void salsa20WordToByte(int[] nArray, byte[] byArray) {
        int n;
        int n2;
        System.arraycopy(nArray, 0, this.x, 0, nArray.length);
        for (n2 = 0; n2 < 10; ++n2) {
            this.x[4] = this.x[4] ^ this.rotl(this.x[0] + this.x[12], 7);
            this.x[8] = this.x[8] ^ this.rotl(this.x[4] + this.x[0], 9);
            this.x[12] = this.x[12] ^ this.rotl(this.x[8] + this.x[4], 13);
            this.x[0] = this.x[0] ^ this.rotl(this.x[12] + this.x[8], 18);
            this.x[9] = this.x[9] ^ this.rotl(this.x[5] + this.x[1], 7);
            this.x[13] = this.x[13] ^ this.rotl(this.x[9] + this.x[5], 9);
            this.x[1] = this.x[1] ^ this.rotl(this.x[13] + this.x[9], 13);
            this.x[5] = this.x[5] ^ this.rotl(this.x[1] + this.x[13], 18);
            this.x[14] = this.x[14] ^ this.rotl(this.x[10] + this.x[6], 7);
            this.x[2] = this.x[2] ^ this.rotl(this.x[14] + this.x[10], 9);
            this.x[6] = this.x[6] ^ this.rotl(this.x[2] + this.x[14], 13);
            this.x[10] = this.x[10] ^ this.rotl(this.x[6] + this.x[2], 18);
            this.x[3] = this.x[3] ^ this.rotl(this.x[15] + this.x[11], 7);
            this.x[7] = this.x[7] ^ this.rotl(this.x[3] + this.x[15], 9);
            this.x[11] = this.x[11] ^ this.rotl(this.x[7] + this.x[3], 13);
            this.x[15] = this.x[15] ^ this.rotl(this.x[11] + this.x[7], 18);
            this.x[1] = this.x[1] ^ this.rotl(this.x[0] + this.x[3], 7);
            this.x[2] = this.x[2] ^ this.rotl(this.x[1] + this.x[0], 9);
            this.x[3] = this.x[3] ^ this.rotl(this.x[2] + this.x[1], 13);
            this.x[0] = this.x[0] ^ this.rotl(this.x[3] + this.x[2], 18);
            this.x[6] = this.x[6] ^ this.rotl(this.x[5] + this.x[4], 7);
            this.x[7] = this.x[7] ^ this.rotl(this.x[6] + this.x[5], 9);
            this.x[4] = this.x[4] ^ this.rotl(this.x[7] + this.x[6], 13);
            this.x[5] = this.x[5] ^ this.rotl(this.x[4] + this.x[7], 18);
            this.x[11] = this.x[11] ^ this.rotl(this.x[10] + this.x[9], 7);
            this.x[8] = this.x[8] ^ this.rotl(this.x[11] + this.x[10], 9);
            this.x[9] = this.x[9] ^ this.rotl(this.x[8] + this.x[11], 13);
            this.x[10] = this.x[10] ^ this.rotl(this.x[9] + this.x[8], 18);
            this.x[12] = this.x[12] ^ this.rotl(this.x[15] + this.x[14], 7);
            this.x[13] = this.x[13] ^ this.rotl(this.x[12] + this.x[15], 9);
            this.x[14] = this.x[14] ^ this.rotl(this.x[13] + this.x[12], 13);
            this.x[15] = this.x[15] ^ this.rotl(this.x[14] + this.x[13], 18);
        }
        n2 = 0;
        for (n = 0; n < 16; ++n) {
            this.intToByteLittle(this.x[n] + nArray[n], byArray, n2);
            n2 += 4;
        }
        for (n = 16; n < this.x.length; ++n) {
            this.intToByteLittle(this.x[n], byArray, n2);
            n2 += 4;
        }
    }

    private byte[] intToByteLittle(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >>> 8);
        byArray[n2 + 2] = (byte)(n >>> 16);
        byArray[n2 + 3] = (byte)(n >>> 24);
        return byArray;
    }

    private int rotl(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    private int byteToIntLittle(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    private void resetCounter() {
        this.cW0 = 0;
        this.cW1 = 0;
        this.cW2 = 0;
    }

    private boolean limitExceeded() {
        ++this.cW0;
        if (this.cW0 == 0) {
            ++this.cW1;
            if (this.cW1 == 0) {
                ++this.cW2;
                return (this.cW2 & 0x20) != 0;
            }
        }
        return false;
    }

    private boolean limitExceeded(int n) {
        if (this.cW0 >= 0) {
            this.cW0 += n;
        } else {
            this.cW0 += n;
            if (this.cW0 >= 0) {
                ++this.cW1;
                if (this.cW1 == 0) {
                    ++this.cW2;
                    return (this.cW2 & 0x20) != 0;
                }
            }
        }
        return false;
    }
}

