/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;

public enum Delimiter {
    EMPTY(' '){

        @Override
        public void escape(CharSequence s, int start, int end, Appendable appendable) throws IOException {
            while (start < end) {
                char c = s.charAt(start++);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        appendable.append('\\');
                    }
                }
                appendable.append(c);
            }
        }
    }
    ,
    SINGLE_QUOTE('\''){

        @Override
        public void escape(CharSequence s, int start, int end, Appendable appendable) throws IOException {
            while (start < end) {
                while (start < end) {
                    char c = s.charAt(start++);
                    switch (c) {
                        case '\'': 
                        case '\\': {
                            appendable.append('\\');
                        }
                    }
                    appendable.append(c);
                }
            }
        }
    }
    ,
    DOUBLE_QUOTE('\"'){

        @Override
        public void escape(CharSequence s, int start, int end, Appendable appendable) throws IOException {
            while (start < end) {
                while (start < end) {
                    char c = s.charAt(start++);
                    switch (c) {
                        case '\"': 
                        case '\\': {
                            appendable.append('\\');
                        }
                    }
                    appendable.append(c);
                }
            }
        }
    };

    private final char value;

    private Delimiter(char value) {
        this.value = value;
    }

    public char getValue() {
        return this.value;
    }

    public final String escape(CharSequence s) {
        try {
            StringBuilder buffer = new StringBuilder();
            this.escape(s, buffer);
            return buffer.toString();
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public final void escape(CharSequence s, Appendable appendable) throws IOException {
        this.escape(s, 0, s.length(), appendable);
    }

    public abstract void escape(CharSequence var1, int var2, int var3, Appendable var4) throws IOException;
}

