/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command;

import java.io.IOException;
import java.util.Map;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.InvocationContext;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.RuntimeContext;
import org.crsh.command.ScriptException;
import org.crsh.shell.InteractionContext;
import org.crsh.shell.ScreenContext;
import org.crsh.shell.impl.command.CRaSHSession;
import org.crsh.shell.impl.command.PipeLineFactory;
import org.crsh.shell.impl.command.PipeLineParser;
import org.crsh.text.Chunk;
import org.crsh.text.RenderPrintWriter;

final class InvocationContextImpl<P>
implements InvocationContext<P> {
    private final InteractionContext<P> producerContext;
    private final RuntimeContext sessionContext;
    private RenderPrintWriter writer;

    InvocationContextImpl(CommandContext<P> producerContext) {
        this.producerContext = producerContext;
        this.sessionContext = producerContext;
    }

    InvocationContextImpl(InteractionContext<P> producerContext, RuntimeContext sessionContext) {
        this.producerContext = producerContext;
        this.sessionContext = sessionContext;
    }

    @Override
    public RenderPrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new RenderPrintWriter(new ScreenContext<Chunk>(){

                @Override
                public int getWidth() {
                    return InvocationContextImpl.this.producerContext.getWidth();
                }

                @Override
                public int getHeight() {
                    return InvocationContextImpl.this.producerContext.getHeight();
                }

                @Override
                public Class<Chunk> getConsumedType() {
                    return Chunk.class;
                }

                @Override
                public void provide(Chunk element) throws IOException {
                    Class consumedType = InvocationContextImpl.this.producerContext.getConsumedType();
                    if (consumedType.isInstance(element)) {
                        Object p = consumedType.cast(element);
                        InvocationContextImpl.this.producerContext.provide(p);
                    }
                }

                @Override
                public void flush() throws IOException {
                    InvocationContextImpl.this.producerContext.flush();
                }
            });
        }
        return this.writer;
    }

    @Override
    public boolean takeAlternateBuffer() throws IOException {
        return this.producerContext.takeAlternateBuffer();
    }

    @Override
    public boolean releaseAlternateBuffer() throws IOException {
        return this.producerContext.releaseAlternateBuffer();
    }

    @Override
    public CommandInvoker<?, ?> resolve(String s) throws ScriptException, IOException {
        CRaSHSession session = (CRaSHSession)this.getSession();
        PipeLineParser parser = new PipeLineParser(s);
        PipeLineFactory factory = parser.parse();
        try {
            return factory.create(session);
        }
        catch (NoSuchCommandException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Class<P> getConsumedType() {
        return this.producerContext.getConsumedType();
    }

    @Override
    public String getProperty(String propertyName) {
        return this.producerContext.getProperty(propertyName);
    }

    @Override
    public String readLine(String msg, boolean echo) {
        return this.producerContext.readLine(msg, echo);
    }

    @Override
    public int getWidth() {
        return this.producerContext.getWidth();
    }

    @Override
    public int getHeight() {
        return this.producerContext.getHeight();
    }

    @Override
    public void provide(P element) throws IOException {
        this.producerContext.provide(element);
    }

    @Override
    public void flush() throws IOException {
        this.producerContext.flush();
    }

    @Override
    public Map<String, Object> getSession() {
        return this.sessionContext.getSession();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.sessionContext.getAttributes();
    }

    public InvocationContextImpl<P> leftShift(Object o) throws IOException {
        if (this.producerContext.getConsumedType().isInstance(o)) {
            Object p = this.producerContext.getConsumedType().cast(o);
            this.producerContext.provide(p);
        }
        return this;
    }
}

