/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    private static final Pattern p = Pattern.compile("\\S+");

    public static List<String> chunks(CharSequence s) {
        ArrayList<String> chunks = new ArrayList<String>();
        Matcher m = p.matcher(s);
        while (m.find()) {
            chunks.add(m.group());
        }
        return chunks;
    }

    public static String join(Iterable<String> strings, String separator) {
        Iterator<String> i = strings.iterator();
        if (i.hasNext()) {
            String first = i.next();
            if (i.hasNext()) {
                StringBuilder buf = new StringBuilder();
                buf.append(first);
                while (i.hasNext()) {
                    buf.append(separator);
                    buf.append(i.next());
                }
                return buf.toString();
            }
            return first;
        }
        return "";
    }

    public static String[] split(CharSequence s, char separator) {
        return Strings.foo(s, separator, 0, 0, 0);
    }

    public static String[] split(CharSequence s, char separator, int rightPadding) {
        if (rightPadding < 0) {
            throw new IllegalArgumentException("Right padding cannot be negative");
        }
        return Strings.foo(s, separator, 0, 0, rightPadding);
    }

    private static String[] foo(CharSequence s, char separator, int count, int from, int rightPadding) {
        int len = s.length();
        if (from < len) {
            String[] ret;
            int to;
            for (to = from; to < len && s.charAt(to) != separator; ++to) {
            }
            if (to == len - 1) {
                ret = new String[count + 2 + rightPadding];
                ret[count + 1] = "";
            } else {
                ret = to == len ? new String[count + 1 + rightPadding] : Strings.foo(s, separator, count + 1, to + 1, rightPadding);
            }
            ret[count] = from == to ? "" : s.subSequence(from, to).toString();
            return ret;
        }
        if (from == len) {
            return new String[count + rightPadding];
        }
        throw new AssertionError();
    }

    public static String findLongestCommonPrefix(CharSequence ... seqs) {
        return Strings.findLongestCommonPrefix(Arrays.asList(seqs));
    }

    public static String findLongestCommonPrefix(Iterable<? extends CharSequence> seqs) {
        String common = "";
        block0: while (true) {
            String candidate = null;
            for (CharSequence charSequence : seqs) {
                if (common.length() + 1 > charSequence.length()) break block0;
                if (candidate == null) {
                    candidate = charSequence.subSequence(0, common.length() + 1).toString();
                    continue;
                }
                if (!charSequence.subSequence(0, common.length() + 1).toString().equals(candidate)) break block0;
            }
            if (candidate == null) break;
            common = candidate;
        }
        return common;
    }
}

