/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.core.session.IoSession;
import org.apache.sshd.common.AbstractSessionIoHandler;
import org.apache.sshd.common.SessionListener;
import org.apache.sshd.common.session.AbstractSession;

public abstract class AbstractSessionFactory
extends AbstractSessionIoHandler {
    protected final List<SessionListener> listeners = new ArrayList<SessionListener>();

    protected AbstractSession createSession(IoSession ioSession) throws Exception {
        AbstractSession session = this.doCreateSession(ioSession);
        ArrayList<SessionListener> sl = new ArrayList<SessionListener>(this.listeners);
        for (SessionListener l : sl) {
            l.sessionCreated(session);
            session.addListener(l);
        }
        return session;
    }

    protected abstract AbstractSession doCreateSession(IoSession var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        List<SessionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SessionListener listener) {
        List<SessionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }
}

