/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.auth;

import java.io.File;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.auth.FilePublicKeyProvider;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;

public class KeyAuthenticationPlugin
extends CRaSHPlugin<KeyAuthenticationPlugin>
implements AuthenticationPlugin<PublicKey> {
    private static final String[] TYPES = new String[]{"ssh-dss", "ssh-rsa"};
    public static final PropertyDescriptor<String> AUTHORIZED_KEY_PATH = PropertyDescriptor.create((String)"auth.key.path", (String)null, (String)"The path to the authorized key file");
    private Set<PublicKey> authorizedKeys = Collections.emptySet();

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Arrays.asList(AUTHORIZED_KEY_PATH);
    }

    public String getName() {
        return "key";
    }

    public KeyAuthenticationPlugin getImplementation() {
        return this;
    }

    public Class<PublicKey> getCredentialType() {
        return PublicKey.class;
    }

    public void init() {
        String authorizedKeyPath = (String)this.getContext().getProperty(AUTHORIZED_KEY_PATH);
        if (authorizedKeyPath != null) {
            File f = new File(authorizedKeyPath);
            if (f.exists() && f.isFile()) {
                this.log.log(Level.FINE, "Found authorized key path " + authorizedKeyPath);
                LinkedHashSet<PublicKey> keys = new LinkedHashSet<PublicKey>();
                FilePublicKeyProvider provider = new FilePublicKeyProvider(new String[]{authorizedKeyPath});
                for (String type : TYPES) {
                    PublicKey key;
                    KeyPair pair = provider.loadKey(type);
                    if (pair == null || (key = pair.getPublic()) == null) continue;
                    keys.add(key);
                }
                this.authorizedKeys = keys;
            } else {
                this.log.log(Level.FINE, "Ignoring invalid authorized key path " + authorizedKeyPath);
            }
        }
    }

    public boolean authenticate(String username, PublicKey credential) throws Exception {
        if (this.authorizedKeys.contains(credential)) {
            this.log.log(Level.FINE, "Authenticated " + username + " with public key " + credential);
            return true;
        }
        this.log.log(Level.FINE, "Denied " + username + " with public key " + credential);
        return false;
    }
}

