/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import org.apache.sshd.common.util.SecurityUtils;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.ssh.term.SSHLifeCycle;
import org.crsh.vfs.Resource;

public class SSHPlugin
extends CRaSHPlugin<SSHPlugin> {
    public static final PropertyDescriptor<Integer> SSH_PORT = PropertyDescriptor.create((String)"ssh.port", (Integer)2000, (String)"The SSH port");
    public static final PropertyDescriptor<String> SSH_SERVER_KEYPATH = PropertyDescriptor.create((String)"ssh.keypath", (String)null, (String)"The path to the key file");
    private SSHLifeCycle lifeCycle;

    public SSHPlugin getImplementation() {
        return this;
    }

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Arrays.asList(SSH_PORT, SSH_SERVER_KEYPATH, AuthenticationPlugin.AUTH);
    }

    public void init() {
        String serverKeyPath;
        Resource serverKeyRes;
        SecurityUtils.setRegisterBouncyCastle(true);
        Integer port = (Integer)this.getContext().getProperty(SSH_PORT);
        if (port == null) {
            this.log.log(Level.INFO, "Could not boot SSHD due to missing due to missing port configuration");
            return;
        }
        Resource serverKey = null;
        URL serverKeyURL = SSHPlugin.class.getResource("/crash/hostkey.pem");
        if (serverKeyURL != null) {
            try {
                this.log.log(Level.FINE, "Found embedded key url " + serverKeyURL);
                serverKey = new Resource(serverKeyURL);
            }
            catch (IOException e) {
                this.log.log(Level.FINE, "Could not load ssh key from url " + serverKeyURL, e);
            }
        }
        if ((serverKeyRes = this.getContext().loadResource("hostkey.pem", ResourceKind.CONFIG)) != null) {
            serverKey = serverKeyRes;
            this.log.log(Level.FINE, "Found server ssh key url");
        }
        if ((serverKeyPath = (String)this.getContext().getProperty(SSH_SERVER_KEYPATH)) != null) {
            this.log.log(Level.FINE, "Found server key path " + serverKeyPath);
            File f = new File(serverKeyPath);
            if (f.exists() && f.isFile()) {
                try {
                    serverKeyURL = f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    this.log.log(Level.FINE, "Ignoring invalid server key " + serverKeyPath, e);
                }
            } else {
                this.log.log(Level.FINE, "Ignoring invalid server key path " + serverKeyPath);
            }
        }
        if (serverKeyURL == null) {
            this.log.log(Level.INFO, "Could not boot SSHD due to missing server key");
            return;
        }
        AuthenticationPlugin authPlugin = AuthenticationPlugin.NULL;
        String authentication = (String)this.getContext().getProperty(AuthenticationPlugin.AUTH);
        if (authentication != null) {
            for (AuthenticationPlugin authenticationPlugin : this.getContext().getPlugins(AuthenticationPlugin.class)) {
                if (!authentication.equals(authenticationPlugin.getName())) continue;
                authPlugin = authenticationPlugin;
                break;
            }
        }
        this.log.log(Level.INFO, "Booting SSHD");
        SSHLifeCycle lifeCycle = new SSHLifeCycle(this.getContext(), authPlugin);
        lifeCycle.setPort(port);
        lifeCycle.setKey(serverKey);
        lifeCycle.init();
        this.lifeCycle = lifeCycle;
    }

    public void destroy() {
        if (this.lifeCycle != null) {
            this.log.log(Level.INFO, "Shutting down SSHD");
            this.lifeCycle.destroy();
            this.lifeCycle = null;
        }
    }
}

