/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import org.crsh.cli.completers.AbstractPathCompleter;
import org.crsh.text.formatter.BindingRenderable;
import org.crsh.util.TypeResolver;
import org.crsh.util.Utils;

public class JNDIHandler {
    public static List<BindingRenderable.BindingData> lookup(List<String> filters, String name, Boolean verbose) {
        Pattern pattern = null;
        if (name != null) {
            pattern = Pattern.compile("^" + Utils.globexToRegex(name) + "$");
        }
        ArrayList<BindingRenderable.BindingData> data = new ArrayList<BindingRenderable.BindingData>();
        data.addAll(JNDIHandler.get(filters, pattern, verbose, ""));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:/"));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:comp/env/jdbc"));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:jboss"));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:global"));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:app"));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:module"));
        return data;
    }

    static List<BindingRenderable.BindingData> get(List<String> filters, Pattern pattern, Boolean verbose, String path) {
        return JNDIHandler.get(filters, pattern, verbose, path, path, null);
    }

    static List<BindingRenderable.BindingData> get(List<String> filters, Pattern pattern, Boolean verbose, String path, String search, Context ctx) {
        ArrayList<BindingRenderable.BindingData> data = new ArrayList<BindingRenderable.BindingData>();
        try {
            if (ctx == null) {
                ctx = new InitialContext();
            }
            if (path.length() > 0) {
                path = path + "/";
            }
            NamingEnumeration<Binding> e = ctx.listBindings(search);
            while (e.hasMoreElements()) {
                Binding instance = e.next();
                String fullName = path + instance.getName();
                if ((filters == null || filters.size() == 0 || TypeResolver.instanceOf(instance.getObject().getClass(), filters)) && (pattern == null || pattern.matcher(fullName).find())) {
                    data.add(new BindingRenderable.BindingData(fullName, instance.getClassName(), instance, verbose));
                }
                if (!(instance.getObject() instanceof Context)) continue;
                data.addAll(JNDIHandler.get(filters, pattern, verbose, fullName, "", (Context)instance.getObject()));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return data;
    }

    public static class JNDICompleter
    extends AbstractPathCompleter<String> {
        private final String[] filters;
        private List<BindingRenderable.BindingData> bindings;

        public JNDICompleter(String ... filters) {
            this.filters = filters;
            this.bindings = JNDIHandler.lookup(Arrays.asList(filters), null, true);
        }

        protected String getCurrentPath() {
            return "";
        }

        protected String getPath(String path) {
            return path;
        }

        protected boolean exists(String path) {
            if (path.equals("/") || path.endsWith("/")) {
                return true;
            }
            for (BindingRenderable.BindingData binding : this.bindings) {
                if (!binding.name.startsWith(path.substring(1) + "/")) continue;
                return true;
            }
            return false;
        }

        protected boolean isDirectory(String path) {
            if (path.equals("/")) {
                return true;
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            for (BindingRenderable.BindingData binding : this.bindings) {
                if (!binding.name.startsWith(path + "/")) continue;
                return true;
            }
            return false;
        }

        protected boolean isFile(String path) {
            if (path.equals("/")) {
                return false;
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                for (BindingRenderable.BindingData binding : this.bindings) {
                    if (!binding.name.equals(path.substring(0, path.length() - 1))) continue;
                    return true;
                }
            }
            return false;
        }

        protected Collection<String> getChilren(String path) {
            ArrayList<String> l = new ArrayList<String>();
            for (BindingRenderable.BindingData binding : this.bindings) {
                if (!path.equals("/") && !binding.name.startsWith(path.substring(1))) continue;
                String completion = binding.name.substring(path.substring(1).length());
                if (completion.startsWith("/")) {
                    completion = completion.substring(1);
                }
                l.add(completion);
            }
            return l;
        }

        protected String getName(String path) {
            return path;
        }
    }
}

