/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term.scp;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.crsh.plugin.PluginContext;
import org.crsh.ssh.term.FailCommand;
import org.crsh.ssh.term.scp.CommandPlugin;

public class SCPCommandFactory
implements CommandFactory {
    private static final Logger log = Logger.getLogger(SCPCommandFactory.class.getName());
    private final PluginContext pluginContext;

    public SCPCommandFactory(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    @Override
    public Command createCommand(String command) {
        command = command.trim();
        log.log(Level.FINE, "About to execute shell command " + command);
        for (CommandPlugin plugin : this.pluginContext.getPlugins(CommandPlugin.class)) {
            Command cmd = plugin.createCommand(command);
            if (cmd == null) continue;
            return cmd;
        }
        return new FailCommand("Unrecognized command " + command);
    }
}

