/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.bootstrap;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.bootstrap.CommandProvider;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.descriptor.HelpDescriptor;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.lang.CommandFactory;

public class Main {
    public static void main(String[] args) throws Exception {
        ServiceLoader<CommandProvider> loader = ServiceLoader.load(CommandProvider.class);
        Iterator<CommandProvider> iterator = loader.iterator();
        if (iterator.hasNext()) {
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    line.append(' ');
                }
                Delimiter.EMPTY.escape(args[i], line);
            }
            CommandProvider commandProvider = iterator.next();
            Class<?> commandClass = commandProvider.getCommandClass();
            Main.handle(commandClass, line.toString());
        }
    }

    private static <T> void handle(Class<T> commandClass, String line) throws Exception {
        T instance;
        CommandDescriptorImpl<T> descriptor = CommandFactory.DEFAULT.create(commandClass);
        InvocationMatcher<T> matcher = (descriptor = HelpDescriptor.create(descriptor)).invoker("main");
        InvocationMatch<T> match = matcher.match(line);
        Object o = match.invoke(instance = commandClass.newInstance());
        if (o != null) {
            System.out.println(o);
        }
    }
}

