/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh;

import java.net.URL;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.ssh.term.SSHLifeCycle;
import org.crsh.vfs.Resource;

public class SSHPlugin
extends CRaSHPlugin {
    private SSHLifeCycle lifeCycle;

    public void init() {
        String keyPath;
        Integer port = (Integer)this.getContext().getProperty(PropertyDescriptor.SSH_PORT);
        if (port == null) {
            this.log.info("Could not boot SSHD due to missing due to missing port configuration");
            return;
        }
        Resource res = this.getContext().loadResource("hostkey.pem", ResourceKind.KEY);
        URL keyURL = null;
        if (res != null) {
            keyURL = res.getURL();
        }
        if ((keyPath = (String)this.getContext().getProperty(PropertyDescriptor.SSH_KEYPATH)) == null && keyURL == null) {
            this.log.info("Could not boot SSHD due to missing key");
            return;
        }
        this.log.info("Booting SSHD");
        SSHLifeCycle lifeCycle = new SSHLifeCycle(this.getContext());
        lifeCycle.setKeyPath(keyPath);
        lifeCycle.setPort(port);
        lifeCycle.setKeyURL(keyURL);
        lifeCycle.init();
        this.lifeCycle = lifeCycle;
    }

    public void destroy() {
        if (this.lifeCycle != null) {
            this.log.info("Shutting down SSHD");
            this.lifeCycle.destroy();
            this.lifeCycle = null;
        }
    }
}

