/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.io.IOException;
import org.apache.sshd.server.Environment;
import org.crsh.Processor;
import org.crsh.ProcessorListener;
import org.crsh.shell.Shell;
import org.crsh.shell.concurrent.AsyncShell;
import org.crsh.shell.impl.CRaSH;
import org.crsh.ssh.term.AbstractCommand;
import org.crsh.ssh.term.CRaSHCommandFactory;
import org.crsh.ssh.term.SSHContext;
import org.crsh.ssh.term.SSHIO;
import org.crsh.term.BaseTerm;
import org.crsh.term.Term;
import org.crsh.term.spi.TermIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRaSHCommand
extends AbstractCommand
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CRaSHCommandFactory factory;
    private Thread thread;
    private SSHContext context;
    private SSHIO io;
    private Processor processor;

    public CRaSHCommand(CRaSHCommandFactory factory) {
        this.factory = factory;
    }

    public void start(Environment env) throws IOException {
        final CRaSH shell = this.factory.builder.build();
        final AsyncShell asyncShell = new AsyncShell(this.factory.executor, (Shell)shell);
        this.context = new SSHContext(env);
        this.io = new SSHIO(this);
        this.processor = new Processor((Term)new BaseTerm((TermIO)this.io), (Shell)asyncShell);
        this.processor.addListener(new ProcessorListener(){

            public void closed() {
                CRaSHCommand.this.io.close();
            }
        });
        this.processor.addListener(new ProcessorListener(){

            public void closed() {
                asyncShell.close();
            }
        });
        this.processor.addListener(new ProcessorListener(){

            public void closed() {
                shell.close();
            }
        });
        this.thread = new Thread((Runnable)this, "CRaSH");
        this.thread.start();
    }

    public SSHContext getContext() {
        return this.context;
    }

    public void destroy() {
        this.io.closed.set(true);
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.processor.run();
        }
        finally {
            this.callback.onExit(0);
        }
    }
}

