/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLKeyPairProvider
extends AbstractKeyPairProvider {
    private static final Logger LOG = LoggerFactory.getLogger(URLKeyPairProvider.class);
    private final URL url;

    public URLKeyPairProvider(URL url) {
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyPair[] loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>();
        if (this.url != null) {
            try {
                InputStream in = this.url.openStream();
                PEMReader r = new PEMReader(new InputStreamReader(in));
                try {
                    Object o = r.readObject();
                    if (o instanceof KeyPair) {
                        keys.add((KeyPair)o);
                    }
                }
                finally {
                    r.close();
                }
            }
            catch (Exception e) {
                LOG.info("Unable to read key {}: {}", (Object)this.url, (Object)e);
            }
        }
        return keys.toArray(new KeyPair[keys.size()]);
    }
}

