/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import org.apache.sshd.common.PtyMode;
import org.apache.sshd.server.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHContext {
    private static final Logger log = LoggerFactory.getLogger(SSHContext.class);
    public final int verase;
    private final Environment env;

    public SSHContext(Environment env) {
        if (env == null) {
            throw new NullPointerException("No null env");
        }
        Integer verase = (Integer)env.getPtyModes().get(PtyMode.VERASE);
        this.env = env;
        this.verase = verase != null ? verase : -1;
    }

    public int getWidth() {
        String s = (String)this.env.getEnv().get("COLUMNS");
        int width = 0;
        if (s != null) {
            try {
                width = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse ssh term width " + s);
            }
        }
        return width;
    }

    public int getHeight() {
        String s = (String)this.env.getEnv().get("COLUMNS");
        int width = 0;
        if (s != null) {
            try {
                width = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse ssh term width " + s);
            }
        }
        return width;
    }

    public String getProperty(String key) {
        return (String)this.env.getEnv().get(key);
    }
}

