/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.crsh.TestPluginLifeCycle;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.auth.SimpleAuthenticationPlugin;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.ssh.SSHClient;
import org.crsh.ssh.SSHPlugin;
import org.crsh.term.CodeType;
import org.crsh.term.IOAction;
import org.crsh.term.IOEvent;
import org.crsh.term.IOHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SSHTestCase
extends Assert {
    private IOHandler handler;
    private SSHClient client;
    private TestPluginLifeCycle lifeCycle;
    private static final AtomicInteger PORTS = new AtomicInteger(2000);

    @Before
    public void setUp() throws Exception {
        int port = PORTS.getAndIncrement();
        IOHandler handler = new IOHandler();
        SimpleAuthenticationPlugin auth = new SimpleAuthenticationPlugin();
        TestPluginLifeCycle lifeCycle = new TestPluginLifeCycle(new CRaSHPlugin[]{new SSHPlugin(), handler, auth});
        lifeCycle.setProperty(SSHPlugin.SSH_PORT, (Object)port);
        lifeCycle.setProperty(SSHPlugin.SSH_SERVER_IDLE_TIMEOUT, (Object)600000);
        lifeCycle.setProperty(SSHPlugin.SSH_SERVER_AUTH_TIMEOUT, (Object)600000);
        lifeCycle.setProperty(AuthenticationPlugin.AUTH, (Object)auth.getName());
        lifeCycle.setProperty(SimpleAuthenticationPlugin.SIMPLE_USERNAME, (Object)"root");
        lifeCycle.setProperty(SimpleAuthenticationPlugin.SIMPLE_PASSWORD, (Object)"");
        lifeCycle.start();
        SSHClient client = new SSHClient(port).connect();
        this.handler = handler;
        this.client = client;
        this.lifeCycle = lifeCycle;
    }

    @Test
    public void testServerReadAfterClientClose() throws Exception {
        this.client.write("a").flush();
        this.handler.add(IOAction.read());
        this.handler.assertEvent((IOEvent)new IOEvent.IO('a'));
        this.client.close();
        this.handler.add(IOAction.read()).add(IOAction.end());
        this.handler.assertEvent((IOEvent)new IOEvent.IO(CodeType.CLOSE));
        this.lifeCycle.stop();
    }

    @Test
    public void testClientCloseDuringServerRead() throws Exception {
        this.client.write("a").flush();
        this.handler.add(IOAction.read());
        this.handler.assertEvent((IOEvent)new IOEvent.IO('a'));
        this.handler.add(IOAction.read()).add(IOAction.end());
        this.client.close();
        this.handler.assertEvent((IOEvent)new IOEvent.IO(CodeType.CLOSE));
        this.lifeCycle.stop();
    }

    @Test
    public void testClientWrite() throws Exception {
        this.client.write("HELLO").flush();
        this.handler.add(IOAction.read());
        this.handler.add(IOAction.read());
        this.handler.add(IOAction.read());
        this.handler.add(IOAction.read());
        this.handler.add(IOAction.read());
        this.handler.add(IOAction.end());
        this.handler.assertEvent((IOEvent)new IOEvent.IO('H'));
        this.handler.assertEvent((IOEvent)new IOEvent.IO('E'));
        this.handler.assertEvent((IOEvent)new IOEvent.IO('L'));
        this.handler.assertEvent((IOEvent)new IOEvent.IO('L'));
        this.handler.assertEvent((IOEvent)new IOEvent.IO('O'));
        this.client.close();
        this.lifeCycle.stop();
    }

    @Test
    public void testServerClose() throws Exception {
        this.client.write("a").flush();
        this.handler.add(IOAction.read());
        this.handler.assertEvent((IOEvent)new IOEvent.IO('a'));
        this.handler.add(IOAction.close()).add(IOAction.read()).add(IOAction.end());
        this.handler.assertEvent((IOEvent)new IOEvent.IO(CodeType.CLOSE));
        try {
            this.client.write("foo");
            SSHTestCase.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lifeCycle.stop();
    }

    @Test
    public void testServerWriteChars() throws Exception {
        this.handler.add(IOAction.write((String)"HOLA"));
        this.handler.add(IOAction.flush());
        SSHTestCase.assertEquals((long)72L, (long)this.client.read());
        SSHTestCase.assertEquals((long)79L, (long)this.client.read());
        SSHTestCase.assertEquals((long)76L, (long)this.client.read());
        SSHTestCase.assertEquals((long)65L, (long)this.client.read());
        this.lifeCycle.stop();
        SSHTestCase.assertEquals((long)-1L, (long)this.client.read());
    }

    @Test
    public void testServerWriteCRLF() throws Exception {
        this.handler.add(IOAction.crlf());
        this.handler.add(IOAction.flush());
        SSHTestCase.assertEquals((long)13L, (long)this.client.read());
        SSHTestCase.assertEquals((long)10L, (long)this.client.read());
        this.handler.add(IOAction.write((String)"\r\n"));
        this.handler.add(IOAction.flush());
        SSHTestCase.assertEquals((long)13L, (long)this.client.read());
        SSHTestCase.assertEquals((long)10L, (long)this.client.read());
        this.lifeCycle.stop();
        SSHTestCase.assertEquals((long)-1L, (long)this.client.read());
    }

    @Test
    public void testServerWriteDel() throws Exception {
        this.handler.add(IOAction.del());
        this.handler.add(IOAction.flush());
        SSHTestCase.assertEquals((long)27L, (long)this.client.read());
        SSHTestCase.assertEquals((long)91L, (long)this.client.read());
        SSHTestCase.assertEquals((long)68L, (long)this.client.read());
        SSHTestCase.assertEquals((long)32L, (long)this.client.read());
        SSHTestCase.assertEquals((long)27L, (long)this.client.read());
        SSHTestCase.assertEquals((long)91L, (long)this.client.read());
        SSHTestCase.assertEquals((long)68L, (long)this.client.read());
        this.lifeCycle.stop();
        SSHTestCase.assertEquals((long)-1L, (long)this.client.read());
    }

    @Test
    public void testServerMoveLeft() throws Exception {
        this.handler.add(IOAction.left());
        this.handler.add(IOAction.flush());
        SSHTestCase.assertEquals((long)27L, (long)this.client.read());
        SSHTestCase.assertEquals((long)91L, (long)this.client.read());
        SSHTestCase.assertEquals((long)49L, (long)this.client.read());
        SSHTestCase.assertEquals((long)68L, (long)this.client.read());
        this.lifeCycle.stop();
        SSHTestCase.assertEquals((long)-1L, (long)this.client.read());
    }
}

