/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.github.benmanes.caffeine.cache.CacheLoader;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import java.util.function.Consumer;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.event.BrokenDirFileEvent;
import org.cryptomator.cryptofs.event.FilesystemEvent;

@CryptoFileSystemScoped
class DirectoryIdLoader
implements CacheLoader<Path, String> {
    private static final int MAX_DIR_ID_LENGTH = 1000;
    private final Consumer<FilesystemEvent> eventConsumer;

    @Inject
    public DirectoryIdLoader(Consumer<FilesystemEvent> eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String load(Path dirFilePath) throws IOException {
        try (FileChannel ch = FileChannel.open(dirFilePath, StandardOpenOption.READ);){
            String string;
            block18: {
                InputStream in = Channels.newInputStream(ch);
                try {
                    long size = ch.size();
                    if (size == 0L) {
                        this.eventConsumer.accept(new BrokenDirFileEvent(dirFilePath));
                        throw new IOException("Invalid, empty directory file: " + String.valueOf(dirFilePath));
                    }
                    if (size > 1000L) {
                        this.eventConsumer.accept(new BrokenDirFileEvent(dirFilePath));
                        throw new IOException("Unexpectedly large directory file: " + String.valueOf(dirFilePath));
                    }
                    assert (size <= 1000L);
                    byte[] bytes = in.readNBytes((int)size);
                    assert ((long)bytes.length == size);
                    string = new String(bytes, StandardCharsets.UTF_8);
                    if (in == null) break block18;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return string;
        }
        catch (NoSuchFileException e) {
            return UUID.randomUUID().toString();
        }
    }
}

