/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.dirid;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.cryptomator.cryptofs.CiphertextDirectory;
import org.cryptomator.cryptofs.DirectoryIdBackup;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;

public class MissingContentDir
implements DiagnosticResult {
    final String dirId;
    final Path dirFile;

    MissingContentDir(String dirId, Path dirFile) {
        this.dirId = dirId;
        this.dirFile = dirFile;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.WARN;
    }

    @Override
    public String toString() {
        return String.format("dir.c9r file (%s) points to non-existing directory.", this.dirFile);
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Directory ID", this.dirId, "Directory ID File", this.dirFile.toString());
    }

    void fix(Path pathToVault, Cryptor cryptor) throws IOException {
        String dirIdHash = cryptor.fileNameCryptor().hashDirectoryId(this.dirId);
        Path dirPath = pathToVault.resolve("d").resolve(dirIdHash.substring(0, 2)).resolve(dirIdHash.substring(2, 32));
        Files.createDirectories(dirPath, new FileAttribute[0]);
        DirectoryIdBackup.write(cryptor, new CiphertextDirectory(this.dirId, dirPath));
    }

    @Override
    public Optional<DiagnosticResult.Fix> getFix(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor) {
        return Optional.of(() -> this.fix(pathToVault, cryptor));
    }
}

