/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration.v6;

import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.text.Normalizer;
import org.cryptomator.cryptofs.common.BackupHelper;
import org.cryptomator.cryptofs.migration.api.MigrationContinuationListener;
import org.cryptomator.cryptofs.migration.api.MigrationProgressListener;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version6Migrator
implements Migrator {
    private static final Logger LOG = LoggerFactory.getLogger(Version6Migrator.class);
    private final SecureRandom csprng;

    @Inject
    public Version6Migrator(SecureRandom csprng) {
        this.csprng = csprng;
    }

    @Override
    public void migrate(Path vaultRoot, String vaultConfigFilename, String masterkeyFilename, CharSequence passphrase, MigrationProgressListener progressListener, MigrationContinuationListener continuationListener) throws CryptoException, IOException {
        LOG.info("Upgrading {} from version 5 to version 6.", (Object)vaultRoot);
        progressListener.update(MigrationProgressListener.ProgressState.INITIALIZING, 0.0);
        Path masterkeyFile = vaultRoot.resolve(masterkeyFilename);
        byte[] fileContentsBeforeUpgrade = Files.readAllBytes(masterkeyFile);
        MasterkeyFileAccess masterkeyFileAccess = new MasterkeyFileAccess(new byte[0], this.csprng);
        try (Masterkey masterkey = masterkeyFileAccess.load(masterkeyFile, passphrase);){
            Path masterkeyBackupFile = BackupHelper.attemptBackup(masterkeyFile);
            LOG.info("Backed up masterkey from {} to {}.", (Object)masterkeyFile.getFileName(), (Object)masterkeyBackupFile.getFileName());
            progressListener.update(MigrationProgressListener.ProgressState.FINALIZING, 0.0);
            masterkeyFileAccess.persist(masterkey, masterkeyFile, (CharSequence)Normalizer.normalize(passphrase, Normalizer.Form.NFC), 6);
            LOG.info("Updated masterkey.");
        }
        LOG.info("Upgraded {} from version 5 to version 6.", (Object)vaultRoot);
    }
}

