/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.cryptomator.frontend.fuse.mount.WinFspMountProvider;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;

@Priority(value=100)
@OperatingSystem(value=OperatingSystem.Value.WINDOWS)
public class WinFspNetworkMountProvider
extends WinFspMountProvider {
    private static final Pattern HOST_NAME_PATTERN_NEGATED = Pattern.compile("[^a-zA-Z0-9-._~]+");

    @Override
    public String displayName() {
        return "WinFsp";
    }

    @Override
    public Set<MountCapability> capabilities() {
        return EnumSet.of(MountCapability.FILE_SYSTEM_NAME, new MountCapability[]{MountCapability.LOOPBACK_HOST_NAME, MountCapability.MOUNT_AS_DRIVE_LETTER, MountCapability.MOUNT_FLAGS, MountCapability.READ_ONLY, MountCapability.UNMOUNT_FORCED, MountCapability.VOLUME_ID, MountCapability.VOLUME_NAME});
    }

    @Override
    public MountBuilder forFileSystem(Path vfsRoot) {
        return new WinFspNetworkMountBuilder(vfsRoot);
    }

    private static class WinFspNetworkMountBuilder
    extends WinFspMountProvider.WinFspMountBuilder {
        private String loopbackHostName = "localhost";
        private String volumeId = UUID.randomUUID().toString();

        public WinFspNetworkMountBuilder(Path vfsRoot) {
            super(vfsRoot);
        }

        public MountBuilder setVolumeId(String id) {
            this.volumeId = id;
            return this;
        }

        @Override
        public MountBuilder setMountpoint(Path mountPoint) {
            if (mountPoint.getRoot().equals(mountPoint)) {
                this.mountPoint = mountPoint;
                return this;
            }
            throw new IllegalArgumentException("mount point must be a drive letter");
        }

        public MountBuilder setLoopbackHostName(String hostName) {
            if (HOST_NAME_PATTERN_NEGATED.matcher(hostName).find()) {
                throw new IllegalArgumentException("Loopback host may only contain the characters a-z, A-Z, 0-9 and -._~");
            }
            this.loopbackHostName = hostName;
            return this;
        }

        @Override
        protected Set<String> combinedMountFlags() {
            Set<String> combined = super.combinedMountFlags();
            combined.removeIf(flag -> flag.startsWith("-oVolumePrefix="));
            combined.removeIf(flag -> flag.startsWith("-oUNC="));
            combined.add("-oUNC=/" + this.loopbackHostName + "/" + this.volumeId + "/" + this.volumeName);
            return combined;
        }
    }
}

