/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.linux.quickaccess;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.DisplayName;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.quickaccess.QuickAccessService;
import org.cryptomator.integrations.quickaccess.QuickAccessServiceException;
import org.cryptomator.linux.quickaccess.FileConfiguredQuickAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@DisplayName(value="KDE Dolphin Places")
@CheckAvailability
@OperatingSystem(value=OperatingSystem.Value.LINUX)
@Priority(value=90)
public class DolphinPlaces
extends FileConfiguredQuickAccess
implements QuickAccessService {
    private static final Logger LOG = LoggerFactory.getLogger(DolphinPlaces.class);
    private static final String XBEL_NAMESPACE = "http://www.freedesktop.org/standards/desktop-bookmarks";
    private static final int MAX_FILE_SIZE = 0x100000;
    private static final Path PLACES_FILE = Path.of(System.getProperty("user.home"), ".local/share/user-places.xbel");
    private static final Validator XML_VALIDATOR;

    public DolphinPlaces() {
        super(PLACES_FILE, 0x100000);
    }

    public DolphinPlaces(Path configFilePath) {
        super(configFilePath, 0x100000);
    }

    @Override
    FileConfiguredQuickAccess.EntryAndConfig addEntryToConfig(String config, Path target, String displayName) throws QuickAccessServiceException {
        try {
            String id = UUID.randomUUID().toString();
            LOG.trace("Adding bookmark for target: '{}', displayName: '{}', id: '{}'", new Object[]{target, displayName, id});
            XML_VALIDATOR.validate(new StreamSource(new StringReader(config)));
            Document xmlDocument = this.loadXmlDocument(config);
            NodeList nodeList = this.extractBookmarksByPath(target, xmlDocument);
            this.removeStaleBookmarks(nodeList);
            this.createBookmark(target, displayName, id, xmlDocument);
            String changedConfig = this.documentToString(xmlDocument);
            XML_VALIDATOR.validate(new StreamSource(new StringReader(changedConfig)));
            return new FileConfiguredQuickAccess.EntryAndConfig(new DolphinPlacesEntry(id), changedConfig);
        }
        catch (SAXException e) {
            throw new QuickAccessServiceException("Invalid structure in xbel bookmark file", (Throwable)e);
        }
        catch (IOException e) {
            throw new QuickAccessServiceException("Failed reading/writing the xbel bookmark file", (Throwable)e);
        }
    }

    private void removeStaleBookmarks(NodeList nodeList) {
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node node = nodeList.item(i);
            node.getParentNode().removeChild(node);
        }
    }

    private NodeList extractBookmarksByPath(Path target, Document xmlDocument) throws QuickAccessServiceException {
        try {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            xpath.setXPathVariableResolver(v -> {
                if (v.equals(new QName("uri"))) {
                    return target.toUri().toString();
                }
                throw new IllegalArgumentException();
            });
            String expression = "/xbel/bookmark[info/metadata[@owner='https://cryptomator.org']][@href=$uri]";
            return (NodeList)xpath.compile(expression).evaluate(xmlDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xee) {
            throw new QuickAccessServiceException("Invalid XPath expression", (Throwable)xee);
        }
    }

    private NodeList extractBookmarksById(String id, Document xmlDocument) throws QuickAccessServiceException {
        try {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            xpath.setXPathVariableResolver(v -> {
                if (v.equals(new QName("id"))) {
                    return id;
                }
                throw new IllegalArgumentException();
            });
            String expression = "/xbel/bookmark[info/metadata[@owner='https://cryptomator.org']][info/metadata/id[text()=$id]]";
            return (NodeList)xpath.compile(expression).evaluate(xmlDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xee) {
            throw new QuickAccessServiceException("Invalid XPath expression", (Throwable)xee);
        }
    }

    private Document loadXmlDocument(String config) throws QuickAccessServiceException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            builderFactory.setXIncludeAware(false);
            builderFactory.setExpandEntityReferences(false);
            builderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            builderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            return builder.parse(new ByteArrayInputStream(config.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new QuickAccessServiceException("Error while loading xml file", (Throwable)e);
        }
    }

    private String documentToString(Document xmlDocument) throws QuickAccessServiceException {
        try {
            StringWriter buf = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("doctype-public", "");
            transformer.setOutputProperty("doctype-system", "");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            transformer.transform(new DOMSource(xmlDocument), new StreamResult(buf));
            String content = buf.toString();
            content = content.replaceFirst("\\s*standalone=\"(yes|no)\"", "");
            content = content.replaceFirst("<!DOCTYPE xbel PUBLIC \"\" \"\">", "<!DOCTYPE xbel>");
            return content;
        }
        catch (TransformerException e) {
            throw new QuickAccessServiceException("Error while serializing document to string", (Throwable)e);
        }
    }

    private void createBookmark(Path target, String displayName, String id, Document xmlDocument) throws QuickAccessServiceException {
        try {
            Element bookmark = xmlDocument.createElement("bookmark");
            Element title = xmlDocument.createElement("title");
            Element info = xmlDocument.createElement("info");
            Element metadataBookmark = xmlDocument.createElement("metadata");
            Element metadataOwner = xmlDocument.createElement("metadata");
            Element bookmarkIcon = xmlDocument.createElementNS(XBEL_NAMESPACE, "bookmark:icon");
            Element idElem = xmlDocument.createElement("id");
            bookmark.setAttribute("href", target.toUri().toString());
            title.setTextContent(displayName);
            bookmark.appendChild(title);
            bookmark.appendChild(info);
            info.appendChild(metadataBookmark);
            info.appendChild(metadataOwner);
            metadataBookmark.appendChild(bookmarkIcon);
            metadataOwner.appendChild(idElem);
            metadataBookmark.setAttribute("owner", "http://freedesktop.org");
            bookmarkIcon.setAttribute("name", "drive-harddisk-encrypted");
            metadataOwner.setAttribute("owner", "https://cryptomator.org");
            idElem.setTextContent(id);
            xmlDocument.getDocumentElement().appendChild(bookmark);
        }
        catch (IllegalArgumentException | DOMException e) {
            throw new QuickAccessServiceException("Error while creating bookmark for target: " + String.valueOf(target), (Throwable)e);
        }
    }

    @CheckAvailability
    public static boolean isSupported() {
        return Files.exists(PLACES_FILE, new LinkOption[0]);
    }

    static {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try (InputStream schemaDefinition = DolphinPlaces.class.getResourceAsStream("/xbel-1.0.xsd");){
            StreamSource schemaFile = new StreamSource(schemaDefinition);
            XML_VALIDATOR = factory.newSchema(schemaFile).newValidator();
        }
        catch (IOException | SAXException e) {
            throw new IllegalStateException("Failed to load included XBEL schema definition file.", e);
        }
    }

    private class DolphinPlacesEntry
    extends FileConfiguredQuickAccess.FileConfiguredQuickAccessEntry
    implements QuickAccessService.QuickAccessEntry {
        private final String id;

        DolphinPlacesEntry(String id) {
            this.id = id;
        }

        @Override
        public String removeEntryFromConfig(String config) throws QuickAccessServiceException {
            try {
                Document xmlDocument = DolphinPlaces.this.loadXmlDocument(config);
                NodeList nodeList = DolphinPlaces.this.extractBookmarksById(this.id, xmlDocument);
                DolphinPlaces.this.removeStaleBookmarks(nodeList);
                String changedConfig = DolphinPlaces.this.documentToString(xmlDocument);
                XML_VALIDATOR.validate(new StreamSource(new StringReader(changedConfig)));
                return changedConfig;
            }
            catch (IOException | IllegalStateException | SAXException e) {
                throw new QuickAccessServiceException("Removing entry from KDE places file failed.", (Throwable)e);
            }
        }
    }
}

