/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.linux.quickaccess;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.cryptomator.integrations.quickaccess.QuickAccessService;
import org.cryptomator.integrations.quickaccess.QuickAccessServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FileConfiguredQuickAccess
implements QuickAccessService {
    private static final Logger LOG = LoggerFactory.getLogger(FileConfiguredQuickAccess.class);
    private final int maxFileSize;
    private final Path configFile;
    private final Path tmpFile;
    private final Lock modifyLock = new ReentrantReadWriteLock().writeLock();

    FileConfiguredQuickAccess(Path configFile, int maxFileSize) {
        this.configFile = configFile;
        this.maxFileSize = maxFileSize;
        this.tmpFile = configFile.resolveSibling("." + String.valueOf(configFile.getFileName()) + ".cryptomator.tmp");
        Runtime.getRuntime().addShutdownHook(new Thread(this::cleanup));
    }

    public QuickAccessService.QuickAccessEntry add(Path target, String displayName) throws QuickAccessServiceException {
        try {
            this.modifyLock.lock();
            this.checkFileSize();
            EntryAndConfig entryAndConfig = this.addEntryToConfig(this.readConfig(), target, displayName);
            this.persistConfig(entryAndConfig.config());
            FileConfiguredQuickAccessEntry fileConfiguredQuickAccessEntry = entryAndConfig.entry();
            return fileConfiguredQuickAccessEntry;
        }
        catch (IOException e) {
            throw new QuickAccessServiceException("Failed to add entry to %s.".formatted(this.configFile), (Throwable)e);
        }
        finally {
            this.modifyLock.unlock();
        }
    }

    abstract EntryAndConfig addEntryToConfig(String var1, Path var2, String var3) throws QuickAccessServiceException;

    private String readConfig() throws IOException {
        return Files.readString(this.configFile, StandardCharsets.UTF_8);
    }

    private void persistConfig(String newConfig) throws IOException {
        Files.writeString(this.tmpFile, (CharSequence)newConfig, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        try {
            Files.move(this.tmpFile, this.configFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.move(this.tmpFile, this.configFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void checkFileSize() throws IOException {
        if (Files.size(this.configFile) > (long)this.maxFileSize) {
            throw new IOException("File %s exceeds size of %d bytes".formatted(this.configFile, this.maxFileSize));
        }
    }

    private void cleanup() {
        try {
            Files.deleteIfExists(this.tmpFile);
        }
        catch (IOException e) {
            LOG.warn("Unable to delete {}. Need to be deleted manually.", (Object)this.tmpFile);
        }
    }

    record EntryAndConfig(FileConfiguredQuickAccessEntry entry, String config) {
    }

    protected abstract class FileConfiguredQuickAccessEntry
    implements QuickAccessService.QuickAccessEntry {
        private volatile boolean isRemoved = false;

        protected FileConfiguredQuickAccessEntry() {
        }

        public void remove() throws QuickAccessServiceException {
            try {
                FileConfiguredQuickAccess.this.modifyLock.lock();
                if (this.isRemoved) {
                    return;
                }
                FileConfiguredQuickAccess.this.checkFileSize();
                String config = FileConfiguredQuickAccess.this.readConfig();
                String adjustedConfig = this.removeEntryFromConfig(config);
                FileConfiguredQuickAccess.this.persistConfig(adjustedConfig);
                this.isRemoved = true;
            }
            catch (IOException e) {
                throw new QuickAccessServiceException("Failed to remove entry to %s.".formatted(FileConfiguredQuickAccess.this.configFile), (Throwable)e);
            }
            finally {
                FileConfiguredQuickAccess.this.modifyLock.unlock();
            }
        }

        abstract String removeEntryFromConfig(String var1) throws QuickAccessServiceException;
    }
}

