/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.linux.quickaccess;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.DisplayName;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.quickaccess.QuickAccessService;
import org.cryptomator.integrations.quickaccess.QuickAccessServiceException;
import org.cryptomator.linux.quickaccess.FileConfiguredQuickAccess;

@Priority(value=100)
@CheckAvailability
@OperatingSystem(value=OperatingSystem.Value.LINUX)
@DisplayName(value="GNOME Nautilus Bookmarks")
public class NautilusBookmarks
extends FileConfiguredQuickAccess
implements QuickAccessService {
    private static final int MAX_FILE_SIZE = 4096;
    private static final Path BOOKMARKS_FILE = Path.of(System.getProperty("user.home"), ".config/gtk-3.0/bookmarks");

    public NautilusBookmarks() {
        super(BOOKMARKS_FILE, 4096);
    }

    @Override
    FileConfiguredQuickAccess.EntryAndConfig addEntryToConfig(String config, Path target, String displayName) throws QuickAccessServiceException {
        String uriPath = target.toAbsolutePath().toString().replace(" ", "%20");
        String entryLine = "file://" + uriPath + " " + displayName;
        NautilusQuickAccessEntry entry = new NautilusQuickAccessEntry(this, entryLine);
        String adjustedConfig = config.stripTrailing() + "\n" + entryLine;
        return new FileConfiguredQuickAccess.EntryAndConfig(entry, adjustedConfig);
    }

    @CheckAvailability
    public static boolean isSupported() {
        return Files.exists(BOOKMARKS_FILE, new LinkOption[0]);
    }

    class NautilusQuickAccessEntry
    extends FileConfiguredQuickAccess.FileConfiguredQuickAccessEntry
    implements QuickAccessService.QuickAccessEntry {
        private final String line;

        NautilusQuickAccessEntry(NautilusBookmarks this$0, String line) {
            super(this$0);
            this.line = line;
        }

        @Override
        public String removeEntryFromConfig(String config) throws QuickAccessServiceException {
            return config.lines().map(l -> l.equals(this.line) ? null : l).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        }
    }
}

