/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.linux.tray;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.tray.ActionItem;
import org.cryptomator.integrations.tray.SeparatorItem;
import org.cryptomator.integrations.tray.SubMenuItem;
import org.cryptomator.integrations.tray.TrayIconLoader;
import org.cryptomator.integrations.tray.TrayMenuController;
import org.cryptomator.integrations.tray.TrayMenuException;
import org.cryptomator.integrations.tray.TrayMenuItem;
import org.cryptomator.linux.tray.ActionItemCallback;
import org.cryptomator.linux.util.CheckUtil;
import org.purejava.appindicator.AppIndicator;
import org.purejava.appindicator.GCallback;
import org.purejava.appindicator.GObject;
import org.purejava.appindicator.Gtk;
import org.purejava.appindicator.app_indicator_h;

@Priority(value=1000)
@CheckAvailability
@OperatingSystem(value=OperatingSystem.Value.LINUX)
public class AppindicatorTrayMenuController
implements TrayMenuController {
    private static final String APP_INDICATOR_ID = "org.cryptomator.Cryptomator";
    private static final String SVG_SOURCE_PROPERTY = "cryptomator.integrationsLinux.trayIconsDir";
    private static final Arena ARENA = Arena.global();
    private MemorySegment indicator;
    private MemorySegment menu;

    @CheckAvailability
    public static boolean isAvailable() {
        return AppIndicator.isLoaded();
    }

    public void showTrayIcon(Consumer<TrayIconLoader> iconLoader, Runnable runnable, String s) throws TrayMenuException {
        this.menu = Gtk.newMenu();
        TrayIconLoader.FreedesktopIconName callback = this::showTrayIconWithSVG;
        iconLoader.accept((TrayIconLoader)callback);
        Gtk.widgetShowAll((MemorySegment)this.menu);
        AppIndicator.setStatus((MemorySegment)this.indicator, (int)app_indicator_h.APP_INDICATOR_STATUS_ACTIVE());
    }

    private void showTrayIconWithSVG(String iconName) {
        String svgSourcePath = System.getProperty(SVG_SOURCE_PROPERTY);
        this.indicator = svgSourcePath == null ? AppIndicator.newIndicator((String)APP_INDICATOR_ID, (String)iconName, (int)app_indicator_h.APP_INDICATOR_CATEGORY_APPLICATION_STATUS()) : AppIndicator.newIndicatorWithPath((String)APP_INDICATOR_ID, (String)iconName, (int)app_indicator_h.APP_INDICATOR_CATEGORY_APPLICATION_STATUS(), (String)svgSourcePath);
    }

    public void updateTrayIcon(Consumer<TrayIconLoader> iconLoader) {
        TrayIconLoader.FreedesktopIconName callback = this::updateTrayIconWithSVG;
        iconLoader.accept((TrayIconLoader)callback);
    }

    private void updateTrayIconWithSVG(String iconName) {
        CheckUtil.checkState(this.indicator != null, "Appindicator is not setup. Call showTrayIcon(...) first.");
        AppIndicator.setIcon((MemorySegment)this.indicator, (String)iconName);
    }

    public void updateTrayMenu(List<TrayMenuItem> items) throws TrayMenuException {
        CheckUtil.checkState(this.indicator != null, "Appindicator is not setup. Call showTrayIcon(...) first.");
        this.menu = Gtk.newMenu();
        this.addChildren(this.menu, items);
        Gtk.widgetShowAll((MemorySegment)this.menu);
        AppIndicator.setMenu((MemorySegment)this.indicator, (MemorySegment)this.menu);
    }

    public void onBeforeOpenMenu(Runnable runnable) {
    }

    private void addChildren(MemorySegment menu, List<TrayMenuItem> items) {
        block5: for (TrayMenuItem item : items) {
            TrayMenuItem trayMenuItem;
            Objects.requireNonNull(item);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ActionItem.class, SeparatorItem.class, SubMenuItem.class}, (TrayMenuItem)trayMenuItem, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ActionItem a = (ActionItem)trayMenuItem;
                    MemorySegment gtkMenuItem = Gtk.newMenuItem();
                    Gtk.menuItemSetLabel((MemorySegment)gtkMenuItem, (String)a.title());
                    GObject.signalConnectObject((MemorySegment)gtkMenuItem, (String)"activate", (MemorySegment)GCallback.allocate((GCallback.Function)new ActionItemCallback(a), (Arena)ARENA), (MemorySegment)menu, (int)0);
                    Gtk.widgetSetSensitive((MemorySegment)gtkMenuItem, (boolean)a.enabled());
                    Gtk.menuShellAppend((MemorySegment)menu, (MemorySegment)gtkMenuItem);
                    continue block5;
                }
                case 1: {
                    MemorySegment gtkSeparator = Gtk.newMenuItem();
                    Gtk.menuShellAppend((MemorySegment)menu, (MemorySegment)gtkSeparator);
                    continue block5;
                }
                case 2: 
            }
            SubMenuItem s = (SubMenuItem)trayMenuItem;
            MemorySegment gtkMenuItem = Gtk.newMenuItem();
            MemorySegment gtkSubmenu = Gtk.newMenu();
            Gtk.menuItemSetLabel((MemorySegment)gtkMenuItem, (String)s.title());
            this.addChildren(gtkSubmenu, s.items());
            Gtk.menuItemSetSubmenu((MemorySegment)gtkMenuItem, (MemorySegment)gtkSubmenu);
            Gtk.menuShellAppend((MemorySegment)menu, (MemorySegment)gtkMenuItem);
        }
    }
}

