/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.generators.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.lang.reflect.Field;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.BomReference;
import org.cyclonedx.util.VersionJsonAnnotationIntrospector;
import org.cyclonedx.util.mixin.MixInBomReference;
import org.cyclonedx.util.serializer.ComponentWrapperSerializer;
import org.cyclonedx.util.serializer.DependencySerializer;
import org.cyclonedx.util.serializer.InputTypeSerializer;
import org.cyclonedx.util.serializer.LicenseChoiceSerializer;
import org.cyclonedx.util.serializer.LifecycleSerializer;
import org.cyclonedx.util.serializer.MetadataSerializer;
import org.cyclonedx.util.serializer.OutputTypeSerializer;
import org.cyclonedx.util.serializer.TrimStringSerializer;

public abstract class AbstractBomJsonGenerator
extends CycloneDxSchema
implements BomJsonGenerator {
    protected final ObjectMapper mapper = new ObjectMapper();
    private final DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();

    public AbstractBomJsonGenerator() {
        this.setupObjectMapper(this.mapper);
        this.setupPrettyPrinter(this.prettyPrinter);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private void setupPrettyPrinter(DefaultPrettyPrinter prettyPrinter) {
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
    }

    private void setupObjectMapper(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new VersionJsonAnnotationIntrospector(String.valueOf(this.getSchemaVersion().getVersion())));
        SimpleModule licenseModule = new SimpleModule();
        SimpleModule depModule = new SimpleModule();
        SimpleModule componentWrapperModule = new SimpleModule();
        SimpleModule stringModule = new SimpleModule();
        stringModule.addSerializer((JsonSerializer)new TrimStringSerializer());
        mapper.registerModule((Module)stringModule);
        licenseModule.addSerializer((JsonSerializer)new LicenseChoiceSerializer());
        mapper.registerModule((Module)licenseModule);
        SimpleModule lifecycleModule = new SimpleModule();
        lifecycleModule.addSerializer((JsonSerializer)new LifecycleSerializer(false));
        mapper.registerModule((Module)lifecycleModule);
        SimpleModule metadataModule = new SimpleModule();
        metadataModule.addSerializer((JsonSerializer)new MetadataSerializer(false, this.getSchemaVersion()));
        mapper.registerModule((Module)metadataModule);
        SimpleModule inputTypeModule = new SimpleModule();
        inputTypeModule.addSerializer((JsonSerializer)new InputTypeSerializer(false));
        mapper.registerModule((Module)inputTypeModule);
        SimpleModule outputTypeModule = new SimpleModule();
        outputTypeModule.addSerializer((JsonSerializer)new OutputTypeSerializer(false));
        mapper.registerModule((Module)outputTypeModule);
        depModule.addSerializer((JsonSerializer)new DependencySerializer(false, null));
        mapper.registerModule((Module)depModule);
        componentWrapperModule.addSerializer((JsonSerializer)new ComponentWrapperSerializer(mapper));
        mapper.registerModule((Module)componentWrapperModule);
    }

    String toJson(Bom bom, boolean prettyPrint) throws GeneratorException {
        try {
            this.mapper.addMixIn(BomReference.class, MixInBomReference.class);
            if (prettyPrint) {
                return this.mapper.writer((PrettyPrinter)this.prettyPrinter).writeValueAsString((Object)bom);
            }
            return this.mapper.writeValueAsString((Object)bom);
        }
        catch (JsonProcessingException e) {
            throw new GeneratorException(e);
        }
    }

    Bom injectBomFormatAndSpecVersion(Bom bom) throws GeneratorException {
        try {
            Field field = Bom.class.getDeclaredField("bomFormat");
            field.setAccessible(true);
            field.set(bom, "CycloneDX");
            field = Bom.class.getDeclaredField("specVersion");
            field.setAccessible(true);
            field.set(bom, this.getSchemaVersion().getVersionString());
            return bom;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new GeneratorException(e);
        }
    }
}

