/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.BomReference;
import org.cyclonedx.model.VersionFilter;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"aggregate", "assemblies", "dependencies", "vulnerabilities"})
public class Composition {
    @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
    @JsonProperty(value="bom-ref")
    @VersionFilter(versions={"1.0", "1.1", "1.2", "1.3", "1.4"})
    private String bomRef;
    private Aggregate aggregate;
    private List<BomReference> assemblies;
    private List<BomReference> dependencies;
    @VersionFilter(versions={"1.0", "1.1", "1.2", "1.3", "1.4"})
    private List<BomReference> vulnerabilities;

    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(Aggregate aggregate) {
        this.aggregate = aggregate;
    }

    @JacksonXmlElementWrapper(localName="assemblies")
    @JacksonXmlProperty(localName="assembly")
    public List<BomReference> getAssemblies() {
        return this.assemblies;
    }

    public void setAssemblies(List<BomReference> assemblies) {
        this.assemblies = assemblies;
    }

    public void addAssembly(BomReference assembly) {
        if (this.assemblies == null) {
            this.assemblies = new ArrayList<BomReference>();
        }
        this.assemblies.add(assembly);
    }

    @JacksonXmlElementWrapper(localName="dependencies")
    @JacksonXmlProperty(localName="dependency")
    public List<BomReference> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<BomReference> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(BomReference dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<BomReference>();
        }
        this.dependencies.add(dependency);
    }

    @JacksonXmlElementWrapper(localName="vulnerabilities")
    @JacksonXmlProperty(localName="vulnerability")
    public List<BomReference> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public void setVulnerabilities(List<BomReference> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    public void addVulnerability(BomReference vulnerability) {
        if (this.vulnerabilities == null) {
            this.vulnerabilities = new ArrayList<BomReference>();
        }
        this.vulnerabilities.add(vulnerability);
    }

    public static enum Aggregate {
        COMPLETE("complete"),
        INCOMPLETE("incomplete"),
        INCOMPLETE_FIRST_PARTY_ONLY("incomplete_first_party_only"),
        INCOMPLETE_FIRST_PARTY_PROPRIETARY_ONLY("incomplete_first_party_proprietary_only"),
        INCOMPLETE_FIRST_PARTY_OPENSOURCE_ONLY("incomplete_first_party_opensource_only"),
        INCOMPLETE_THIRD_PARTY_ONLY("incomplete_third_party_only"),
        INCOMPLETE_THIRD_PARTY_PROPRIETARY_ONLY("incomplete_third_party_proprietary_only"),
        INCOMPLETE_THIRD_PARTY_OPENSOURCE_ONLY("incomplete_third_party_opensource_only"),
        UNKNOWN("unknown"),
        NOT_SPECIFIED("not_specified");

        private final String name;

        public String getAggregateName() {
            return this.name;
        }

        private Aggregate(String name) {
            this.name = name;
        }
    }
}

