/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.util.serializer.ExternalReferenceSerializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSerialize(using=ExternalReferenceSerializer.class)
@JsonPropertyOrder(value={"url", "comment", "hashes"})
public class ExternalReference {
    private String url;
    @JacksonXmlProperty(localName="type", isAttribute=true)
    private Type type;
    private String comment;
    @VersionFilter(versions={"1.0", "1.1", "1.2"})
    private List<Hash> hashes;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @JacksonXmlElementWrapper(localName="hashes")
    @JacksonXmlProperty(localName="hash")
    public List<Hash> getHashes() {
        return this.hashes;
    }

    public void setHashes(List<Hash> hashes) {
        this.hashes = hashes;
    }

    public void addHash(Hash hash) {
        if (this.hashes == null) {
            this.hashes = new ArrayList<Hash>();
        }
        this.hashes.add(hash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalReference)) {
            return false;
        }
        ExternalReference reference = (ExternalReference)o;
        return Objects.equals(this.url, reference.url) && this.type == reference.type && Objects.equals(this.comment, reference.comment) && Objects.equals(this.hashes, reference.hashes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.type, this.comment, this.hashes});
    }

    public static enum Type {
        VCS("vcs"),
        ISSUE_TRACKER("issue-tracker"),
        WEBSITE("website"),
        ADVISORIES("advisories"),
        BOM("bom"),
        MAILING_LIST("mailing-list"),
        SOCIAL("social"),
        CHAT("chat"),
        DOCUMENTATION("documentation"),
        SUPPORT("support"),
        DISTRIBUTION("distribution"),
        DISTRIBUTION_INTAKE("distribution-intake"),
        LICENSE("license"),
        BUILD_META("build-meta"),
        BUILD_SYSTEM("build-system"),
        RELEASE_NOTES("release-notes"),
        SECURITY_CONTACT("security-contact"),
        MODEL_CARD("model_card"),
        ATTESTATION("attestation"),
        THREAT_MODEL("threat-model"),
        ADVERSARY_MODEL("adversary-model"),
        RISK_ASSESSMENT("risk-assessment"),
        VULNERABILITY_ASSERTION("vulnerability-assertion"),
        EXPLOITABILITY_STATEMENT("exploitability-statement"),
        PENTEST_REPORT("pentest-report"),
        STATIC_ANALYSIS_REPORT("static-analysis-report"),
        DYNAMIC_ANALYSIS_REPORT("dynamic-analysis-report"),
        RUNTIME_ANALYSIS_REPORT("runtime-analysis-report"),
        COMPONENT_ANALYSIS_REPORT("component-analysis-report"),
        MATURITY_REPORT("maturity-report"),
        CERTIFICATION_REPORT("certification-report"),
        CODIFIED_INFRASTRUCTURE("codified-infrastructure"),
        QUALITY_METRICS("quality-metrics"),
        LOG("log"),
        CONFIGURATION("configuration"),
        EVIDENCE("evidence"),
        FORMULATION("formulation"),
        OTHER("other");

        private final String name;

        public String getTypeName() {
            return this.name;
        }

        private Type(String name) {
            this.name = name;
        }

        public static Type fromString(String text) {
            for (Type t : Type.values()) {
                if (!t.name.equals(text)) continue;
                return t;
            }
            return null;
        }
    }
}

