/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;

public class LicenseDeserializer
extends JsonDeserializer<LicenseChoice> {
    public LicenseChoice deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode rootNode = (JsonNode)p.getCodec().readTree(p);
        if (!rootNode.isEmpty()) {
            ArrayNode nodes = rootNode.isArray() ? (ArrayNode)rootNode : new ArrayNode(null).add(rootNode);
            LicenseChoice licenseChoice = new LicenseChoice();
            for (JsonNode node : nodes) {
                if (node.has("license")) {
                    this.processLicenseNode(p, node.get("license"), licenseChoice);
                    continue;
                }
                if (!node.has("expression")) continue;
                licenseChoice.setExpression(node.get("expression").asText());
                return licenseChoice;
            }
            return licenseChoice;
        }
        return null;
    }

    private void processLicenseNode(JsonParser p, JsonNode licenseNode, LicenseChoice licenseChoice) throws IOException {
        ArrayNode licenseNodes = licenseNode.isArray() ? (ArrayNode)licenseNode : new ArrayNode(null).add(licenseNode);
        for (JsonNode license : licenseNodes) {
            License licenseObj = (License)p.getCodec().treeToValue((TreeNode)license, License.class);
            licenseChoice.addLicense(licenseObj);
        }
    }
}

