/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StringListDeserializer
extends JsonDeserializer<List<String>> {
    public List<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (p.getCurrentName().equalsIgnoreCase("aliases")) {
            return this.deserializeList(node, "alias");
        }
        if (p.getCurrentName().equalsIgnoreCase("tags")) {
            return this.deserializeList(node, "tag");
        }
        if (p.getCurrentName().equalsIgnoreCase("endpoints")) {
            return this.deserializeList(node, "endpoint");
        }
        if (p.getCurrentName().equalsIgnoreCase("altIds")) {
            return this.deserializeList(node, "altId");
        }
        return null;
    }

    private List<String> deserializeList(JsonNode node, String itemName) {
        ArrayList<String> list = new ArrayList<String>();
        if (node.has(itemName)) {
            node = node.get(itemName);
        }
        if (node != null) {
            if (node.isArray()) {
                for (JsonNode nodeObject : node) {
                    list.add(nodeObject.asText());
                }
            } else {
                list.add(node.asText());
            }
        }
        return list;
    }
}

