/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.cyclonedx.model.formulation.common.EnvVariableChoice;
import org.cyclonedx.model.formulation.common.OutputType;

public class OutputTypeSerializer
extends StdSerializer<OutputType> {
    private final boolean isXml;

    public OutputTypeSerializer(boolean isXml) {
        this(null, isXml);
    }

    public OutputTypeSerializer(Class<OutputType> t, boolean isXml) {
        super(t);
        this.isXml = isXml;
    }

    public void serialize(OutputType value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            xmlGenerator.writeStartObject();
            xmlGenerator.writeFieldName("input");
            this.createOutputChoice(value, (JsonGenerator)xmlGenerator);
            xmlGenerator.writeEndObject();
        } else {
            this.createOutputChoice(value, jsonGenerator);
        }
    }

    private void createOutputChoice(OutputType output, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        if (output.getResource() != null) {
            jsonGenerator.writeFieldName("resource");
            jsonGenerator.writeObject((Object)output.getResource());
        } else if (output.getEnvironmentVars() != null && !output.getEnvironmentVars().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("environmentVars");
            for (EnvVariableChoice envVarChoice : output.getEnvironmentVars()) {
                if (envVarChoice.getEnvironmentVar() != null) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeObjectField("environmentVar", (Object)envVarChoice.getEnvironmentVar());
                    jsonGenerator.writeEndObject();
                    continue;
                }
                if (envVarChoice.getValue() == null) continue;
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("value", (Object)envVarChoice.getValue());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        } else if (output.getData() != null) {
            jsonGenerator.writeFieldName("data");
            jsonGenerator.writeObject((Object)output.getData());
        }
        if (output.getType() != null) {
            jsonGenerator.writeFieldName("type");
            jsonGenerator.writeObject((Object)output.getType());
        }
        if (output.getSource() != null) {
            jsonGenerator.writeFieldName("source");
            jsonGenerator.writeObject((Object)output.getSource());
        }
        if (output.getTarget() != null) {
            jsonGenerator.writeFieldName("target");
            jsonGenerator.writeObject((Object)output.getTarget());
        }
        if (output.getProperties() != null) {
            jsonGenerator.writeFieldName("properties");
            jsonGenerator.writeObject(output.getProperties());
        }
        jsonGenerator.writeEndObject();
    }

    public Class<OutputType> handledType() {
        return OutputType.class;
    }
}

