/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.generators.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cyclonedx.Format;
import org.cyclonedx.Version;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.generators.AbstractBomGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.util.introspector.VersionXmlAnnotationIntrospector;
import org.cyclonedx.util.serializer.DependencySerializer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BomXmlGenerator
extends AbstractBomGenerator {
    private final DefaultXmlPrettyPrinter prettyPrinter;
    protected static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public BomXmlGenerator(Bom bom, Version version) {
        super(version, bom, Format.XML);
        this.mapper = new XmlMapper();
        this.prettyPrinter = new DefaultXmlPrettyPrinter();
        this.setupObjectMapper();
        bom.setXmlns(version.getNamespace());
    }

    private void setupObjectMapper() {
        this.mapper.setAnnotationIntrospector((AnnotationIntrospector)new VersionXmlAnnotationIntrospector(this.getSchemaVersion()));
        if (this.version.getVersion() != 1.0) {
            boolean useNamespace = this.version.getVersion() == 1.1;
            this.registerDependencyModule(this.mapper, useNamespace);
        }
        super.setupObjectMapper(true);
    }

    private void registerDependencyModule(ObjectMapper mapper, boolean useNamespace) {
        SimpleModule depModule = new SimpleModule();
        depModule.addSerializer((JsonSerializer)new DependencySerializer(useNamespace, null));
        mapper.registerModule((Module)depModule);
    }

    private DocumentBuilder buildSecureDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }

    protected Document generateDocument(Bom bom) throws ParserConfigurationException {
        try {
            DocumentBuilder docBuilder = this.buildSecureDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(new StringReader(this.toXML(bom, false))));
            doc.setXmlStandalone(true);
            return doc;
        }
        catch (IOException | ParserConfigurationException | GeneratorException | SAXException ex) {
            throw new ParserConfigurationException(ex.toString());
        }
    }

    String toXML(Bom bom, boolean prettyPrint) throws GeneratorException {
        try {
            if (prettyPrint) {
                return PROLOG + System.lineSeparator() + this.mapper.writer((PrettyPrinter)this.prettyPrinter).writeValueAsString((Object)bom);
            }
            return PROLOG + this.mapper.writeValueAsString((Object)bom);
        }
        catch (JsonProcessingException ex) {
            throw new GeneratorException(ex);
        }
    }

    public Document generate() throws ParserConfigurationException {
        return this.generateDocument(this.bom);
    }

    public String toXmlString() throws GeneratorException {
        return this.toXML(this.bom, true);
    }

    public String toString() {
        try {
            return this.toXML(this.bom, true);
        }
        catch (GeneratorException e) {
            return "";
        }
    }
}

