/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model.component.evidence;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"technique", "confidence", "value"})
@JacksonXmlRootElement(localName="method")
public class Method {
    private Technique technique;
    private Double confidence;
    private String value;

    public Technique getTechnique() {
        return this.technique;
    }

    public void setTechnique(Technique technique) {
        this.technique = technique;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Double confidence) {
        this.confidence = confidence;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Method)) {
            return false;
        }
        Method method = (Method)object;
        return this.technique == method.technique && Objects.equals(this.confidence, method.confidence) && Objects.equals(this.value, method.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.technique, this.confidence, this.value});
    }

    public static enum Technique {
        SOURCE_CODE_ANALYSIS("source-code-analysis"),
        BINARY_ANALYSIS("binary-analysis"),
        MANIFEST_ANALYSIS("manifest-analysis"),
        AST_FINGERPRINT("ast-fingerprint"),
        HASH_COMPARISON("hash-comparison"),
        INSTRUMENTATION("instrumentation"),
        DYNAMIC_ANALYSIS("dynamic-analysis"),
        FILENAME("filename"),
        ATTESTATION("attestation"),
        OTHER("other");

        private final String name;

        public String getTypeName() {
            return this.name;
        }

        private Technique(String name) {
            this.name = name;
        }
    }
}

