/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cyclonedx.model.Licensing;
import org.cyclonedx.util.deserializer.DeserializerUtils;

public class LicensingTypeDeserializer
extends JsonDeserializer<List<Licensing.LicensingType>> {
    public List<Licensing.LicensingType> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        return this.parseLicenseTypes(node.has("licenseType") ? node.get("licenseType") : node);
    }

    private List<Licensing.LicensingType> parseLicenseTypes(JsonNode node) {
        ArrayList<Licensing.LicensingType> types = new ArrayList<Licensing.LicensingType>();
        ArrayNode nodes = DeserializerUtils.getArrayNode(node, null);
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        for (JsonNode typeNode : nodes) {
            types.add(this.parseType(typeNode));
        }
        return types;
    }

    private Licensing.LicensingType parseType(JsonNode node) {
        return Licensing.LicensingType.fromString(node.asText());
    }
}

