/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.dacapo.harness.Benchmark;
import org.dacapo.harness.Callback;
import org.dacapo.harness.CommandLineArgs;
import org.dacapo.parser.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHarness {
    public static final String PROP_BUILD_NICKNAME = "build.nickname";
    public static final String PROP_BUILD_VERSION = "build.version";
    public static final String BUILD_NICKNAME = "Specification-Version";
    public static final String BUILD_VERSION = "Implementation-Version";
    private static String BuildNickName;
    private static String BuildVersion;
    private final Config config;
    private static CommandLineArgs commandLineArgs;
    public static final DecimalFormat two_dp;

    public static String getBuildNickName() {
        return BuildNickName;
    }

    public static String getBuildVersion() {
        return BuildVersion;
    }

    private static URL getURL(String fn) {
        ClassLoader cl = TestHarness.class.getClassLoader();
        if (commandLineArgs.getVerbose()) {
            System.out.println("TestHarness.getURL: returns " + cl.getResource(fn));
        }
        return cl.getResource(fn);
    }

    public static boolean exists(File f) {
        return TestHarness.exists(f.getPath());
    }

    public static boolean exists(String fn) {
        return TestHarness.getURL(fn) != null;
    }

    public static double coeff_of_var(long[] times) {
        double n = times.length;
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < times.length; ++i) {
            double x = times[i];
            sum += x;
            sum2 += x * x;
        }
        double mean = sum / n;
        double sigma = Math.sqrt(1.0 / n * sum2 - mean * mean);
        return sigma / mean;
    }

    public static void main(String[] args) {
        Locale.setDefault(new Locale("en", "AU"));
        System.setProperty("java.awt.headless", "true");
        try {
            commandLineArgs = new CommandLineArgs(args);
            File scratch = new File(commandLineArgs.getScratchDir());
            TestHarness.makeCleanScratch(scratch);
            Benchmark.setCommandLineOptions(commandLineArgs);
            try {
                Config.setThreadCountOverride(Integer.parseInt(commandLineArgs.getThreadCount()));
            }
            catch (RuntimeException re) {
                // empty catch block
            }
            for (String bm : commandLineArgs.benchmarks()) {
                String cnf;
                InputStream ins = null;
                if (commandLineArgs.getCnfOverride() == null) {
                    cnf = "cnf/" + bm + ".cnf";
                    ins = TestHarness.class.getClassLoader().getResourceAsStream(cnf);
                    if (ins == null) {
                        System.err.println("Unknown benchmark: " + bm);
                        System.exit(20);
                    }
                } else {
                    cnf = commandLineArgs.getCnfOverride();
                    try {
                        ins = new FileInputStream(cnf);
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Count not find cnf file: '" + cnf + "'");
                        System.exit(20);
                    }
                }
                TestHarness harness = new TestHarness(ins);
                String size = commandLineArgs.getSize();
                int factor = 0;
                int limit = harness.config.getThreadLimit(size);
                try {
                    factor = Integer.parseInt(commandLineArgs.getThreadFactor());
                    if (0 < factor && harness.config.getThreadModel() == Config.ThreadModel.PER_CPU) {
                        harness.config.setThreadFactor(size, factor);
                    }
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
                if (!harness.isValidSize(size)) {
                    System.err.println("No configuration size, " + size + ", for benchmark " + bm + ".");
                    continue;
                }
                if (factor != 0 && harness.config.getThreadModel() != Config.ThreadModel.PER_CPU) {
                    System.err.println("Can only set the thread factor for per_cpu configurable benchmarks");
                    continue;
                }
                if (!harness.isValidThreadCount(size)) {
                    TestHarness testHarness = harness;
                    if (testHarness.config.getThreadCountOverride() > 0 || factor > 0) {
                        System.err.println("The specified number of threads (" + harness.config.getThreadCount(size) + ") is outside the range [1," + (limit == 0 ? "unlimited" : "" + limit) + "]");
                        continue;
                    }
                }
                if (commandLineArgs.getInformation()) {
                    harness.bmInfo(size);
                    continue;
                }
                if (!harness.isValidThreadCount(size)) {
                    System.err.println("The derived number of threads (" + harness.config.getThreadCount(size) + ") is outside the range [1," + (limit == 0 ? "unlimited" : "" + limit) + "]; rescaling to match thread limit.");
                    Config cfr_ignored_0 = harness.config;
                    Config.setThreadCountOverride(harness.config.getThreadLimit(size));
                }
                harness.dump(commandLineArgs.getVerbose());
                TestHarness.runBenchmark(scratch, bm, harness);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void makeCleanScratch(File scratch) {
        TestHarness.rmdir(scratch);
        scratch.mkdir();
    }

    private boolean isValidSize(String size) {
        return size != null && this.config.getSizes().contains(size);
    }

    private boolean isValidThreadCount(String size) {
        return this.config.getThreadLimit(size) == 0 || this.config.getThreadCount(size) <= this.config.getThreadLimit(size);
    }

    private static void runBenchmark(File scratch, String bm, TestHarness harness) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, Exception {
        harness.config.printThreadModel(System.out, commandLineArgs.getSize(), commandLineArgs.getVerbose());
        Constructor<?> cons = harness.findClass().getConstructor(Config.class, File.class);
        Benchmark b = (Benchmark)cons.newInstance(harness.config, scratch);
        boolean valid = true;
        Callback callback = commandLineArgs.getCallback();
        callback.init(harness.config);
        do {
            boolean bl = valid = b.run(callback, commandLineArgs.getSize()) && valid;
        } while (callback.runAgain());
        b.cleanup();
        if (!valid) {
            System.err.println("Validation FAILED for " + bm + " " + commandLineArgs.getSize());
            if (!commandLineArgs.getIgnoreValidation()) {
                System.exit(-2);
            }
        }
    }

    private static DecimalFormat twoDecimalPlaces() {
        DecimalFormat two_dp = new DecimalFormat();
        two_dp.setMaximumFractionDigits(2);
        two_dp.setMinimumFractionDigits(2);
        two_dp.setGroupingUsed(true);
        return two_dp;
    }

    private static void rmdir(File dir) {
        String[] files = dir.list();
        if (files != null) {
            for (int f = 0; f < files.length; ++f) {
                File file = new File(dir, files[f]);
                if (file.isDirectory()) {
                    TestHarness.rmdir(file);
                }
                if (file.delete()) continue;
                System.err.println("Could not delete " + files[f]);
            }
        }
    }

    public static int TEST(int i) {
        System.err.println("In TEST");
        System.err.println(i);
        return 2 * i;
    }

    private void bmInfo(String size) {
        this.config.describe(System.err, size);
    }

    private void dump(boolean verbose) {
        if (verbose) {
            System.err.println("Class name: " + this.config.className);
            System.err.println("Configurations:");
            this.config.describe(System.err, commandLineArgs.getSize());
        }
    }

    private TestHarness(InputStream stream) {
        try {
            JarFile jarFile = new JarFile(new File(TestHarness.class.getProtectionDomain().getCodeSource().getLocation().getFile()));
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String nickname = attributes.get(new Attributes.Name(BUILD_NICKNAME)).toString();
            String version = attributes.get(new Attributes.Name(BUILD_VERSION)).toString();
            BuildNickName = nickname;
            BuildVersion = version;
        }
        catch (Exception e) {
            BuildNickName = "Unknown";
            BuildVersion = "unknown";
        }
        this.config = Config.parse(stream);
        if (this.config == null) {
            System.exit(-1);
        }
    }

    private Class<?> findClass() {
        try {
            return Class.forName(this.config.className);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    static {
        two_dp = TestHarness.twoDecimalPlaces();
    }
}

