/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.report;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.report.AbstractReportModule;
import org.databene.stat.LatencyCounter;

public class CSVLatencyReportModule
extends AbstractReportModule {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private File file = null;
    OutputStream out;

    public String getReportReferenceLabel(String serviceId) {
        return serviceId == null ? null : "Latency distribution as CSV";
    }

    public String getReportReference(String serviceId) {
        return serviceId == null ? null : this.filename(serviceId);
    }

    public void starting(String serviceId) {
        this.file = new File(this.context.getReportFolder(), this.filename(serviceId));
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(this.file));
            this.writeHeader(serviceId, this.out);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void completed(String serviceId, LatencyCounter[] counters, PerformanceRequirement requirement) {
        this.writeStats(serviceId, counters);
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing " + this.file, e);
        }
    }

    private void writeHeader(String serviceId, OutputStream out) {
        String line = "latency,sampleCount" + LINE_SEPARATOR;
        try {
            out.write(line.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeStats(String serviceId, LatencyCounter[] counters) {
        try {
            LatencyCounter counter = counters[0];
            for (long i = counter.minLatency(); i <= counter.maxLatency(); ++i) {
                String line = i + "," + counter.getLatencyCount(i) + LINE_SEPARATOR;
                this.out.write(line.getBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String filename(String serviceId) {
        return serviceId + ".stat.csv";
    }
}

