/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.util;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.databene.contiperf.Clock;
import org.databene.contiperf.ExecutionConfig;
import org.databene.contiperf.PercentileRequirement;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.PerfTestConfigurationError;
import org.databene.contiperf.PerfTestException;
import org.databene.contiperf.PerfTestExecutionError;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.Required;
import org.databene.contiperf.clock.SystemClock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContiPerfUtil {
    public static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static PerfTestException executionError(Throwable e) {
        Throwable result = e;
        if (result instanceof InvocationTargetException) {
            result = result.getCause();
        }
        if (result instanceof PerfTestException) {
            return (PerfTestException)result;
        }
        return new PerfTestExecutionError(result);
    }

    public static ExecutionConfig mapPerfTestAnnotation(PerfTest annotation) {
        if (annotation != null) {
            return new ExecutionConfig(annotation.invocations(), annotation.threads(), annotation.duration(), ContiPerfUtil.clocks(annotation), annotation.rampUp(), annotation.warmUp(), annotation.cancelOnViolation(), annotation.timer(), annotation.timerParams());
        }
        return null;
    }

    private static Clock[] clocks(PerfTest annotation) {
        Class<? extends Clock>[] clockClasses = annotation.clocks();
        if (clockClasses.length == 0) {
            return new Clock[]{new SystemClock()};
        }
        Clock[] clocks = new Clock[clockClasses.length];
        for (int i = 0; i < clockClasses.length; ++i) {
            clocks[i] = ContiPerfUtil.clock(clockClasses[i]);
        }
        return clocks;
    }

    private static Clock clock(Class<? extends Clock> clockClass) {
        try {
            return clockClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating clock " + clockClass.getName(), e);
        }
    }

    public static PerformanceRequirement mapRequired(Required annotation) {
        PercentileRequirement[] customPercs;
        int percentile99;
        int percentile95;
        int percentile90;
        if (annotation == null) {
            return null;
        }
        int throughput = annotation.throughput();
        int average = annotation.average();
        int max = annotation.max();
        int totalTime = annotation.totalTime();
        ArrayList<PercentileRequirement> percTmp = new ArrayList<PercentileRequirement>();
        int median = annotation.median();
        if (median > 0) {
            percTmp.add(new PercentileRequirement(50, median));
        }
        if ((percentile90 = annotation.percentile90()) > 0) {
            percTmp.add(new PercentileRequirement(90, percentile90));
        }
        if ((percentile95 = annotation.percentile95()) > 0) {
            percTmp.add(new PercentileRequirement(95, percentile95));
        }
        if ((percentile99 = annotation.percentile99()) > 0) {
            percTmp.add(new PercentileRequirement(99, percentile99));
        }
        for (PercentileRequirement percentile : customPercs = ContiPerfUtil.parsePercentiles(annotation.percentiles())) {
            percTmp.add(percentile);
        }
        PercentileRequirement[] percs = new PercentileRequirement[percTmp.size()];
        percTmp.toArray(percs);
        return new PerformanceRequirement(average, max, totalTime, percs, throughput);
    }

    public static PercentileRequirement[] parsePercentiles(String percentilesSpec) {
        if (percentilesSpec == null || percentilesSpec.length() == 0) {
            return new PercentileRequirement[0];
        }
        String[] assignments = percentilesSpec.split(",");
        PercentileRequirement[] reqs = new PercentileRequirement[assignments.length];
        for (int i = 0; i < assignments.length; ++i) {
            reqs[i] = ContiPerfUtil.parsePercentile(assignments[i]);
        }
        return reqs;
    }

    private static PercentileRequirement parsePercentile(String assignment) {
        String[] parts = assignment.split(":");
        if (parts.length != 2) {
            throw new PerfTestConfigurationError("Ilegal percentile syntax: " + assignment);
        }
        int base = Integer.parseInt(parts[0].trim());
        int limit = Integer.parseInt(parts[1].trim());
        return new PercentileRequirement(base, limit);
    }
}

