/**********************************************************************
Copyright (c) 2002 Kelly Grizzle (TJDO) and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 

Contributors:
2002 Mike Martin (TJDO)
2004 Andy Jefferson - removed dependency on JDK 1.4 (Boolean.valueOf(boolean))
2004 Andy Jefferson - updated type handling to use datastoreMappings
2007 Andy Jefferson - removed RDBMS-specifics
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.expression.BooleanBitColumnExpression;
import org.datanucleus.store.mapped.expression.BooleanBitColumnLiteral;
import org.datanucleus.store.mapped.expression.BooleanCharColumnExpression;
import org.datanucleus.store.mapped.expression.BooleanCharColumnLiteral;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;

/**
 * Mapping of Java Boolean object.
 */
public class BooleanMapping extends SingleFieldMapping
{
    /**
     * Accessor for the Java type being represented here.
     * @return The Java type
     */
    public Class getJavaType()
    {
        return Boolean.class;
    }

    // TODO Delete when we drop legacy support
    private static Boolean mappingSampleValue = Boolean.TRUE;
    public Object getSampleValue(ClassLoaderResolver clr)
    {
        return mappingSampleValue;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value)
    {
        ScalarExpression expr;
        if (getNumberOfDatastoreMappings() > 0)
        {
            DatastoreMapping data_mapping = getDatastoreMapping(0);
            if (data_mapping.isBitBased() || data_mapping.isIntegerBased())
            {
                if (storeMgr.getDatastoreAdapter().supportsOption(DatastoreAdapter.BIT_IS_REALLY_BOOLEAN))
                {
                    expr = new BooleanLiteral(qs, this, ((Boolean)value).booleanValue());
                }
                else
                {
                    expr = new BooleanBitColumnLiteral(qs, this, ((Boolean)value).booleanValue());
                }
            }
            else if (data_mapping.isBooleanBased())
            {
                expr = new BooleanLiteral(qs, this, ((Boolean)value).booleanValue());
            }
            else if (data_mapping.isStringBased())
            {
                expr = new BooleanCharColumnLiteral(qs, this, ((Boolean)value).booleanValue());
            }
            else
            {
                expr = new BooleanLiteral(qs, this, ((Boolean)value).booleanValue());
            }
        }
        else
        {
            expr = new BooleanLiteral(qs, this, ((Boolean)value).booleanValue());
        }
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te)
    {
        ScalarExpression expr;
        DatastoreMapping data_mapping = getDatastoreMapping(0);
        if (data_mapping.isBitBased() || data_mapping.isIntegerBased())
        {
            if (storeMgr.getDatastoreAdapter().supportsOption(DatastoreAdapter.BIT_IS_REALLY_BOOLEAN))
            {
                expr = new BooleanExpression(qs, this, te);
            }
            else
            {
                expr = new BooleanBitColumnExpression(qs, this, te);
            }
        }
        else if (data_mapping.isBooleanBased())
        {
            expr = new BooleanExpression(qs, this, te);
        }
        else if (data_mapping.isStringBased())
        {
            expr = new BooleanCharColumnExpression(qs, this, te);
        }
        else
        {
            expr = new BooleanExpression(qs, this, te);
        }

        return expr; 
    }
}