/**********************************************************************
Copyright (c) 2005 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.scostore;

import java.util.Iterator;
import java.util.List;

import org.datanucleus.store.ObjectProvider;

/**
 * Interface representation of the backing store for an array.
 **/
public interface ArrayStore extends Store
{
    /**
     * Accessor for the element type in the collection.
     * @return The element type.
     **/
    String getElementType();
    
    /**
     * Accessor for an iterator for the array.
     * @param sm State Manager for the array. 
     * @return Iterator for the array.
     **/
    Iterator iterator(ObjectProvider sm);

    /**
     * Method to retrieve the elements of the array.
     * @param ownerSM State Manager of the owner
     * @return The List of elements in the array (in the same order)
     */
    List getArray(ObjectProvider ownerSM);

    /**
     * Accessor for the size of the array.
     * @param sm State Manager for the owner. 
     * @return The size of the array.
     */
    int size(ObjectProvider sm);

    /**
     * Method to clear the array.
     * @param ownerSM State Manager for the owner. 
     */
    void clear(ObjectProvider ownerSM);

    /**
     * Method to set the elements in the array.
     * @param ownerSM State Manager for the owner.
     * @param array The array
     * @return Whether the elements were added ok
     */
	boolean set(ObjectProvider ownerSM, Object array);
}