/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.scostore.AbstractCollectionStore;
import org.datanucleus.store.mapped.scostore.AbstractListStoreSpecialization;
import org.datanucleus.store.scostore.ListStore;

public abstract class AbstractListStore
extends AbstractCollectionStore
implements ListStore {
    protected boolean indexedList = true;

    protected AbstractListStore(StoreManager storeMgr, ClassLoaderResolver clr, AbstractListStoreSpecialization specialization) {
        super(storeMgr, clr, specialization);
    }

    private AbstractListStoreSpecialization getSpecialization() {
        return (AbstractListStoreSpecialization)this.specialization;
    }

    public Iterator iterator(ObjectProvider sm) {
        return this.listIterator(sm);
    }

    public ListIterator listIterator(ObjectProvider sm) {
        return this.listIterator(sm, -1, -1);
    }

    protected abstract ListIterator listIterator(ObjectProvider var1, int var2, int var3);

    public boolean add(ObjectProvider sm, Object element, int size) {
        return this.internalAdd(sm, 0, true, Collections.singleton(element), size);
    }

    public void add(ObjectProvider sm, Object element, int index, int size) {
        this.internalAdd(sm, index, false, Collections.singleton(element), size);
    }

    public boolean addAll(ObjectProvider sm, Collection elements, int size) {
        return this.internalAdd(sm, 0, true, elements, size);
    }

    public boolean addAll(ObjectProvider sm, Collection elements, int index, int size) {
        return this.internalAdd(sm, index, false, elements, size);
    }

    protected abstract boolean internalAdd(ObjectProvider var1, int var2, boolean var3, Collection var4, int var5);

    public Object get(ObjectProvider sm, int index) {
        ListIterator iter = this.listIterator(sm, index, index);
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        if (!this.indexedList) {
            Object obj = null;
            int position = 0;
            while (iter.hasNext()) {
                obj = iter.next();
                if (position == index) {
                    return obj;
                }
                ++position;
            }
        }
        return iter.next();
    }

    public int indexOf(ObjectProvider sm, Object element) {
        this.validateElementForReading(sm, element);
        return this.getSpecialization().indexOf(sm, element, this);
    }

    public int lastIndexOf(ObjectProvider sm, Object element) {
        this.validateElementForReading(sm, element);
        return this.getSpecialization().lastIndexOf(sm, element, this);
    }

    public boolean removeAll(ObjectProvider sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        if (this.indexedList) {
            int[] indices = this.getIndicesOf(sm, elements);
            for (int i = 0; i < indices.length; ++i) {
                this.removeAt(sm, indices[i], -1);
                modified = true;
            }
        } else {
            throw new NucleusException("Not yet implemented AbstractListStore.remove for ordered lists");
        }
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            sm.getExecutionContext().deleteObjects(elements.toArray());
        }
        return modified;
    }

    public boolean remove(ObjectProvider sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        Object elementToRemove = element;
        ExecutionContext ec = sm.getExecutionContext();
        if (ec.getApiAdapter().isDetached(element)) {
            elementToRemove = ec.findObject(ec.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        boolean modified = this.internalRemove(sm, elementToRemove, size);
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        boolean dependent = collmd.isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (allowDependentField && dependent && !collmd.isEmbeddedElement()) {
            sm.getExecutionContext().deleteObjectInternal(elementToRemove);
        }
        return modified;
    }

    protected abstract boolean internalRemove(ObjectProvider var1, Object var2, int var3);

    public Object remove(ObjectProvider sm, int index, int size) {
        Object element = this.get(sm, index);
        if (this.indexedList) {
            this.removeAt(sm, index, size);
        } else {
            this.internalRemove(sm, element, size);
        }
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        boolean dependent = collmd.isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent && !collmd.isEmbeddedElement() && !this.contains(sm, element)) {
            sm.getExecutionContext().deleteObjectInternal(element);
        }
        return element;
    }

    protected abstract void removeAt(ObjectProvider var1, int var2, int var3);

    public List subList(ObjectProvider sm, int startIdx, int endIdx) {
        ListIterator iter = this.listIterator(sm, startIdx, endIdx);
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        if (!this.indexedList && list.size() > endIdx - startIdx) {
            return list.subList(startIdx, endIdx);
        }
        return list;
    }

    protected int[] getIndicesOf(ObjectProvider sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            this.validateElementForReading(sm, iter.next());
        }
        return this.getSpecialization().getIndicesOf(sm, elements, this);
    }
}

