/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.sco.simple;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.types.sco.SCOMap;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class TreeMap
extends java.util.TreeMap
implements SCOMap,
Cloneable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected transient Object owner;
    protected transient ObjectProvider ownerSM;
    protected transient String fieldName;
    protected transient int fieldNumber;
    protected java.util.TreeMap delegate;

    public TreeMap(ObjectProvider ownerSM, String fieldName) {
        this.ownerSM = ownerSM;
        this.owner = ownerSM.getObject();
        this.fieldName = fieldName;
        if (ownerSM != null) {
            this.fieldNumber = ownerSM.getClassMetaData().getMetaDataForMember(fieldName).getAbsoluteFieldNumber();
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Map m = (Map)o;
        if (m != null) {
            this.initialiseDelegate();
            this.delegate.putAll(m);
        } else {
            this.initialiseDelegate();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, false, false)));
        }
    }

    public void initialise() {
        this.initialiseDelegate();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, false, false)));
        }
    }

    protected void initialiseDelegate() {
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        Comparator comparator = SCOUtils.getComparator(fmd, this.ownerSM.getExecutionContext().getClassLoaderResolver());
        this.delegate = comparator != null ? new java.util.TreeMap(comparator) : new java.util.TreeMap();
    }

    public Object getValue() {
        return this.delegate;
    }

    public void load() {
    }

    public boolean isLoaded() {
        return true;
    }

    public void flush() {
    }

    public void updateEmbeddedKey(Object key, int fieldNumber, Object newValue) {
        this.makeDirty();
    }

    public void updateEmbeddedValue(Object value, int fieldNumber, Object newValue) {
        this.makeDirty();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.ownerSM != null ? this.ownerSM.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.ownerSM = null;
        }
    }

    public void makeDirty() {
        if (this.owner != null) {
            ((PersistenceCapable)this.owner).jdoMakeDirty(this.fieldName);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        java.util.TreeMap detached = new java.util.TreeMap();
        SCOUtils.detachCopyForMap(this.ownerSM, this.entrySet(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Map m = (Map)value;
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean keysWithoutIdentity = SCOUtils.mapHasKeysWithoutIdentity(fmd);
        boolean valuesWithoutIdentity = SCOUtils.mapHasValuesWithoutIdentity(fmd);
        java.util.TreeMap attachedKeysValues = new java.util.TreeMap();
        SCOUtils.attachCopyForMap(this.ownerSM, m.entrySet(), attachedKeysValues, keysWithoutIdentity, valuesWithoutIdentity);
        SCOUtils.updateMapWithMapKeysValues(this.ownerSM.getExecutionContext().getApiAdapter(), this, attachedKeysValues);
    }

    public Object clone() {
        return this.delegate.clone();
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }

    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public Object firstKey() {
        return this.delegate.firstKey();
    }

    public Object lastKey() {
        return this.delegate.lastKey();
    }

    public SortedMap headMap(Object toKey) {
        return this.delegate.headMap(toKey);
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        return this.delegate.subMap(fromKey, toKey);
    }

    public SortedMap tailMap(Object fromKey) {
        return this.delegate.headMap(fromKey);
    }

    public Object get(Object key) {
        return this.delegate.get(key);
    }

    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public int size() {
        return this.delegate.size();
    }

    public Collection values() {
        return this.delegate.values();
    }

    public void clear() {
        AbstractMemberMetaData mmd;
        if (this.ownerSM != null && !this.delegate.isEmpty() && (SCOUtils.hasDependentKey(mmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName)) || SCOUtils.hasDependentValue(mmd))) {
            for (Map.Entry entry : this.delegate.entrySet()) {
                if (SCOUtils.hasDependentKey(mmd)) {
                    this.ownerSM.getExecutionContext().deleteObjectInternal(entry.getKey());
                }
                if (!SCOUtils.hasDependentValue(mmd)) continue;
                this.ownerSM.getExecutionContext().deleteObjectInternal(entry.getValue());
            }
        }
        this.delegate.clear();
        this.makeDirty();
    }

    public Object put(Object key, Object value) {
        Object oldValue = this.delegate.put(key, value);
        this.makeDirty();
        return oldValue;
    }

    public void putAll(Map m) {
        this.delegate.putAll(m);
        this.makeDirty();
    }

    public Object remove(Object key) {
        AbstractMemberMetaData mmd;
        Object value = this.delegate.remove(key);
        if (this.ownerSM != null && (SCOUtils.hasDependentKey(mmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName)) || SCOUtils.hasDependentValue(mmd))) {
            if (SCOUtils.hasDependentKey(mmd)) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(key);
            }
            if (SCOUtils.hasDependentValue(mmd)) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(value);
            }
        }
        this.makeDirty();
        return value;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.TreeMap(this.delegate);
    }
}

