/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.util.Map;
import java.util.Objects;
import org.dhatim.fastexcel.ColumnStyleSetter;
import org.dhatim.fastexcel.Worksheet;

class Column {
    private final Worksheet worksheet;
    private final int colNumber;
    private int style;

    Column(Worksheet worksheet, int colNumber) {
        this.worksheet = Objects.requireNonNull(worksheet);
        this.colNumber = Objects.requireNonNull(colNumber);
        this.style = 0;
    }

    static Column noStyle(Worksheet worksheet, int c) {
        return new Column(worksheet, c);
    }

    public Worksheet getWorksheet() {
        return this.worksheet;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public ColumnStyleSetter style() {
        return new ColumnStyleSetter(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        return this.colNumber == column.colNumber && Objects.equals(this.worksheet, column.worksheet);
    }

    public int hashCode() {
        return Objects.hash(this.worksheet, this.colNumber);
    }

    Integer getStyle() {
        return this.style;
    }

    void applyStyle(Map<Integer, Integer> stylesMap) {
        this.style = stylesMap.get(this.style);
    }
}

