/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dhatim.fastexcel.Alignment;
import org.dhatim.fastexcel.Border;
import org.dhatim.fastexcel.BorderElement;
import org.dhatim.fastexcel.BorderSide;
import org.dhatim.fastexcel.BorderStyle;
import org.dhatim.fastexcel.ConditionalFormatting;
import org.dhatim.fastexcel.ConditionalFormattingRule;
import org.dhatim.fastexcel.DiagonalProperty;
import org.dhatim.fastexcel.DifferentialFormat;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Font;
import org.dhatim.fastexcel.Protection;
import org.dhatim.fastexcel.ProtectionOption;
import org.dhatim.fastexcel.Range;
import org.dhatim.fastexcel.StylesFunction;
import org.dhatim.fastexcel.Worksheet;

abstract class GenericStyleSetter<STYLE_SETTER extends GenericStyleSetter<STYLE_SETTER>> {
    private final Worksheet worksheet;
    private String valueFormatting;
    private String fillColor;
    private String alternateShadingFillColor;
    private String shadingFillColor;
    private int eachNRows;
    private Boolean bold;
    private Boolean italic;
    private Boolean underlined;
    private String fontName;
    private BigDecimal fontSize;
    private String fontColor;
    private String horizontalAlignment;
    private String verticalAlignment;
    private boolean wrapText;
    private int rotation;
    private int indent;
    private Border border;
    private Map<ProtectionOption, Boolean> protectionOptions;

    GenericStyleSetter(Worksheet worksheet) {
        this.worksheet = worksheet;
    }

    protected abstract STYLE_SETTER getThis();

    public STYLE_SETTER format(String numberingFormat) {
        this.valueFormatting = numberingFormat;
        return this.getThis();
    }

    public STYLE_SETTER fillColor(String rgb) {
        this.fillColor = rgb;
        return this.getThis();
    }

    public STYLE_SETTER shadeAlternateRows(String rgb) {
        this.alternateShadingFillColor = rgb;
        return this.getThis();
    }

    public STYLE_SETTER shadeRows(String rgb, int eachNRows) {
        this.shadingFillColor = rgb;
        this.eachNRows = eachNRows;
        return this.getThis();
    }

    public STYLE_SETTER fontColor(String rgb) {
        this.fontColor = rgb;
        return this.getThis();
    }

    public STYLE_SETTER fontName(String name) {
        this.fontName = name;
        return this.getThis();
    }

    public STYLE_SETTER fontSize(BigDecimal size) {
        this.fontSize = size;
        return this.getThis();
    }

    public STYLE_SETTER fontSize(int size) {
        this.fontSize = BigDecimal.valueOf(size);
        return this.getThis();
    }

    public STYLE_SETTER bold() {
        this.bold = true;
        return this.getThis();
    }

    public STYLE_SETTER italic() {
        this.italic = true;
        return this.getThis();
    }

    public STYLE_SETTER underlined() {
        this.underlined = true;
        return this.getThis();
    }

    public STYLE_SETTER horizontalAlignment(String alignment) {
        this.horizontalAlignment = alignment;
        return this.getThis();
    }

    public STYLE_SETTER verticalAlignment(String alignment) {
        this.verticalAlignment = alignment;
        return this.getThis();
    }

    public STYLE_SETTER wrapText(boolean wrapText) {
        this.wrapText = wrapText;
        return this.getThis();
    }

    public STYLE_SETTER rotation(int degrees) {
        this.rotation = degrees;
        return this.getThis();
    }

    public STYLE_SETTER indent(int indent) {
        this.indent = indent < 0 ? 0 : (indent > 15 ? 15 : indent);
        return this.getThis();
    }

    private STYLE_SETTER borderElement(BorderSide side, BorderElement element) {
        if (this.border == null) {
            this.border = new Border();
        }
        this.border.setElement(side, element);
        return this.getThis();
    }

    public STYLE_SETTER borderStyle(BorderStyle borderStyle) {
        return this.borderStyle(borderStyle.xmlValue);
    }

    public STYLE_SETTER borderStyle(String borderStyle) {
        if (this.border == null) {
            this.border = new Border();
        }
        EnumSet.of(BorderSide.TOP, BorderSide.LEFT, BorderSide.BOTTOM, BorderSide.RIGHT).forEach(side -> this.borderElement((BorderSide)((Object)side), this.border.elements.get(side).updateStyle(borderStyle)));
        return this.getThis();
    }

    public STYLE_SETTER borderStyle(BorderSide side, BorderStyle borderStyle) {
        return this.borderStyle(side, borderStyle.xmlValue);
    }

    public STYLE_SETTER borderStyle(BorderSide side, String borderStyle) {
        if (this.border == null) {
            this.border = new Border();
        }
        return this.borderElement(side, this.border.elements.get((Object)side).updateStyle(borderStyle));
    }

    public STYLE_SETTER borderColor(String borderColor) {
        if (this.border == null) {
            this.border = new Border();
        }
        EnumSet.of(BorderSide.TOP, BorderSide.LEFT, BorderSide.BOTTOM, BorderSide.RIGHT).forEach(side -> this.borderElement((BorderSide)((Object)side), this.border.elements.get(side).updateColor(borderColor)));
        return this.getThis();
    }

    public STYLE_SETTER borderColor(BorderSide side, String borderColor) {
        if (this.border == null) {
            this.border = new Border();
        }
        return this.borderElement(side, this.border.elements.get((Object)side).updateColor(borderColor));
    }

    public STYLE_SETTER diagonalProperty(DiagonalProperty diagonalProperty) {
        if (this.border == null) {
            this.border = new Border();
        }
        this.border.setDiagonalProperty(diagonalProperty);
        return this.getThis();
    }

    public STYLE_SETTER protectionOption(ProtectionOption option, Boolean value) {
        if (this.protectionOptions == null) {
            this.protectionOptions = new EnumMap<ProtectionOption, Boolean>(ProtectionOption.class);
        }
        this.protectionOptions.put(option, value);
        return this.getThis();
    }

    public abstract void set();

    protected void setStyle(boolean shadingEnabled, Set<Integer> currentStyles, StylesFunction stylesFunction) {
        Alignment alignment = this.horizontalAlignment != null || this.verticalAlignment != null || this.wrapText || this.rotation != 0 || this.indent != 0 ? new Alignment(this.horizontalAlignment, this.verticalAlignment, this.wrapText, this.rotation, this.indent) : null;
        Font font = !Font.equalsDefault(this.bold, this.italic, this.underlined, this.fontName, this.fontSize, this.fontColor) ? Font.build(this.bold, this.italic, this.underlined, this.fontName, this.fontSize, this.fontColor) : Font.DEFAULT;
        Fill fill = this.fillColor == null ? Fill.NONE : Fill.fromColor(this.fillColor);
        if (this.border == null) {
            this.border = Border.NONE;
        }
        Protection protection = this.protectionOptions != null ? new Protection(this.protectionOptions) : null;
        Map<Integer, Integer> newStyles = currentStyles.stream().collect(Collectors.toMap(Function.identity(), s -> this.worksheet.getWorkbook().mergeAndCacheStyle((int)s, this.valueFormatting, font, fill, this.border, alignment, protection)));
        stylesFunction.applyStyles(newStyles);
        if (shadingEnabled) {
            if (this.alternateShadingFillColor != null) {
                this.getRange().shadeAlternateRows(Fill.fromColor(this.alternateShadingFillColor, false));
            }
            if (this.shadingFillColor != null) {
                this.getRange().shadeRows(Fill.fromColor(this.shadingFillColor, false), this.eachNRows);
            }
        }
    }

    public void set(ConditionalFormattingRule conditionalFormattingRule) {
        Alignment alignment = null;
        if (this.horizontalAlignment != null || this.verticalAlignment != null || this.wrapText || this.rotation != 0 || this.indent != 0) {
            alignment = new Alignment(this.horizontalAlignment, this.verticalAlignment, this.wrapText, this.rotation, this.indent);
        }
        Font font = null;
        if (this.bold != null && this.bold != false || this.italic != null && this.italic != false || this.underlined != null && this.underlined != false || this.fontColor != null || this.fontName != null || this.fontSize != null) {
            font = Font.build(this.bold, this.italic, this.underlined, this.fontName, this.fontSize, this.fontColor);
        }
        Fill fill = null;
        if (this.fillColor != null) {
            fill = Fill.fromColor(this.fillColor, false);
        }
        Protection protection = null;
        if (this.protectionOptions != null) {
            protection = new Protection(this.protectionOptions);
        }
        int dxfId = this.worksheet.getWorkbook().cacheDifferentialFormat(new DifferentialFormat(this.valueFormatting, font, fill, this.border, alignment, protection));
        conditionalFormattingRule.setDxfId(dxfId);
        ConditionalFormatting conditionalFormatting = new ConditionalFormatting(this.getRange(), conditionalFormattingRule);
        this.worksheet.addConditionalFormatting(conditionalFormatting);
    }

    protected abstract Range getRange();
}

