/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationDataForInclusion;
import eu.europa.esig.dss.validation.ValidationDataForInclusionBuilder;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;

public class CAdESLevelBaselineLT
extends CAdESSignatureExtension {
    private final CertificateVerifier certificateVerifier;
    private final CAdESLevelBaselineT cadesProfileT;

    public CAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier, boolean onlyLastSigner) {
        super(tspSource, onlyLastSigner);
        this.certificateVerifier = certificateVerifier;
        this.cadesProfileT = new CAdESLevelBaselineT(tspSource, onlyLastSigner);
    }

    @Override
    protected SignerInformation extendCMSSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) throws DSSException {
        CAdESSignature cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, parameters.getDetachedContents());
        if (Utils.isCollectionEmpty((Collection)cadesSignature.getSignatureTimestamps())) {
            signerInformation = this.cadesProfileT.extendCMSSignature(cmsSignedData, signerInformation, parameters);
            cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, parameters.getDetachedContents());
        }
        this.assertExtendSignaturePossible(cadesSignature);
        return signerInformation;
    }

    @Override
    public CMSSignedData postExtendCMSSignedData(CMSSignedData cmsSignedData, SignerInformation signerInformation, List<DSSDocument> detachedContents) {
        CAdESSignature cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, detachedContents);
        ValidationDataForInclusionBuilder validationDataForInclusionBuilder = this.getValidationDataForInclusionBuilder(cadesSignature);
        ValidationDataForInclusion validationDataForInclusion = validationDataForInclusionBuilder.build();
        return this.extendWithValidationData(cmsSignedData, validationDataForInclusion, detachedContents);
    }

    protected ValidationDataForInclusionBuilder getValidationDataForInclusionBuilder(CAdESSignature cadesSignature) {
        ValidationContext validationContext = cadesSignature.getSignatureValidationContext(this.certificateVerifier);
        return new ValidationDataForInclusionBuilder(validationContext, cadesSignature.getCompleteCertificateSource());
    }

    protected CMSSignedData extendWithValidationData(CMSSignedData cmsSignedData, ValidationDataForInclusion validationDataForInclusion, List<DSSDocument> detachedContents) {
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        cmsSignedData = cmsSignedDataBuilder.extendCMSSignedData(cmsSignedData, validationDataForInclusion, detachedContents);
        return cmsSignedData;
    }

    private void assertExtendSignaturePossible(CAdESSignature cadesSignature) throws DSSException {
        if (cadesSignature.areAllSelfSignedCertificates()) {
            throw new DSSException("Cannot extend the signature. The signature contains only self-signed certificate chains!");
        }
    }
}

