/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CAdESSignatureExtension
implements SignatureExtension<CAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignatureExtension.class);
    protected final TSPSource tspSource;
    private final boolean onlyLastCMSSignature;

    public CAdESSignatureExtension(TSPSource tspSource, boolean onlyLastCMSSignature) {
        Objects.requireNonNull(tspSource, "Missing TSPSource");
        this.tspSource = tspSource;
        this.onlyLastCMSSignature = onlyLastCMSSignature;
    }

    public CMSSignedDocument extendSignatures(DSSDocument signatureToExtend, CAdESSignatureParameters parameters) {
        CMSSignedDocument cMSSignedDocument;
        block8: {
            LOG.info("EXTEND SIGNATURES.");
            InputStream inputStream = signatureToExtend.openStream();
            try {
                CMSSignedData cmsSignedData = new CMSSignedData(inputStream);
                CMSSignedData extendCMSSignedData = this.extendCMSSignatures(cmsSignedData, parameters);
                cMSSignedDocument = new CMSSignedDocument(extendCMSSignedData);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CMSException e) {
                    throw new DSSException("Cannot parse CMS data", e);
                }
            }
            inputStream.close();
        }
        return cMSSignedDocument;
    }

    public CMSSignedData extendCMSSignatures(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        CMSSignedData extendCMSSignedData = this.onlyLastCMSSignature ? this.extendLastCMSSignature(cmsSignedData, parameters) : this.extendAllCMSSignatures(cmsSignedData, parameters);
        return extendCMSSignedData;
    }

    private CMSSignedData extendAllCMSSignatures(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        LOG.info("EXTEND ALL CMS SIGNATURES.");
        cmsSignedData = this.preExtendCMSSignedData(cmsSignedData, parameters);
        Collection signerInformationCollection = cmsSignedData.getSignerInfos().getSigners();
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationCollection) {
            CAdESSignature cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, parameters.getDetachedContents());
            this.assertSignatureValid(cadesSignature, parameters);
            SignerInformation newSignerInformation = this.extendCMSSignature(cmsSignedData, signerInformation, parameters);
            newSignerInformationList.add(newSignerInformation);
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        cmsSignedData = CMSSignedData.replaceSigners((CMSSignedData)cmsSignedData, (SignerInformationStore)newSignerStore);
        signerInformationCollection = cmsSignedData.getSignerInfos().getSigners();
        for (SignerInformation signerInformation : signerInformationCollection) {
            cmsSignedData = this.postExtendCMSSignedData(cmsSignedData, signerInformation, parameters.getDetachedContents());
        }
        return cmsSignedData;
    }

    private CMSSignedData extendLastCMSSignature(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        LOG.info("EXTEND LAST CMS SIGNATURES.");
        cmsSignedData = this.preExtendCMSSignedData(cmsSignedData, parameters);
        Collection signerInformationCollection = cmsSignedData.getSignerInfos().getSigners();
        SignerInformation lastSignerInformation = this.getFirstSigner(cmsSignedData);
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationCollection) {
            if (lastSignerInformation == signerInformation) {
                CAdESSignature cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, parameters.getDetachedContents());
                this.assertSignatureValid(cadesSignature, parameters);
                SignerInformation newSignerInformation = this.extendCMSSignature(cmsSignedData, signerInformation, parameters);
                newSignerInformationList.add(newSignerInformation);
                continue;
            }
            newSignerInformationList.add(signerInformation);
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        cmsSignedData = CMSSignedData.replaceSigners((CMSSignedData)cmsSignedData, (SignerInformationStore)newSignerStore);
        lastSignerInformation = this.getFirstSigner(cmsSignedData);
        return this.postExtendCMSSignedData(cmsSignedData, lastSignerInformation, parameters.getDetachedContents());
    }

    protected SignerInformation getFirstSigner(CMSSignedData cmsSignedData) {
        Collection signers = cmsSignedData.getSignerInfos().getSigners();
        return (SignerInformation)signers.iterator().next();
    }

    private void assertSignatureValid(CAdESSignature cadesSignature, CAdESSignatureParameters parameters) {
        SignatureCryptographicVerification signatureCryptographicVerification;
        if (!SignatureForm.PAdES.equals((Object)parameters.getSignatureLevel().getSignatureForm()) && !(signatureCryptographicVerification = cadesSignature.getSignatureCryptographicVerification()).isSignatureIntact()) {
            String errorMessage = signatureCryptographicVerification.getErrorMessage();
            throw new DSSException("Cryptographic signature verification has failed" + (errorMessage.isEmpty() ? "." : " / " + errorMessage));
        }
    }

    protected abstract SignerInformation extendCMSSignature(CMSSignedData var1, SignerInformation var2, CAdESSignatureParameters var3);

    protected CMSSignedData preExtendCMSSignedData(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        return cmsSignedData;
    }

    protected CMSSignedData postExtendCMSSignedData(CMSSignedData cmsSignedData, SignerInformation signerInformation, List<DSSDocument> detachedContents) {
        return cmsSignedData;
    }

    protected CAdESSignature newCAdESSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation, List<DSSDocument> detachedContents) {
        CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation);
        cadesSignature.setDetachedContents(detachedContents);
        return cadesSignature;
    }

    protected ASN1Object getTimeStampAttributeValue(byte[] message, CAdESSignatureParameters parameters) {
        DigestAlgorithm timestampDigestAlgorithm = parameters.getSignatureTimestampParameters().getDigestAlgorithm();
        return this.getTimeStampAttributeValue(message, timestampDigestAlgorithm, new Attribute[0]);
    }

    public ASN1Object getTimeStampAttributeValue(byte[] messageToTimestamp, DigestAlgorithm timestampDigestAlgorithm, Attribute ... attributesForTimestampToken) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Message to timestamp is: {}", (Object)Utils.toHex((byte[])messageToTimestamp));
            }
            byte[] timestampDigest = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])messageToTimestamp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Digested ({}) message to timestamp is {}", (Object)timestampDigestAlgorithm, (Object)Utils.toHex((byte[])timestampDigest));
            }
            TimestampBinary timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, timestampDigest);
            CMSSignedData cmsSignedDataTimeStampToken = new CMSSignedData(timeStampToken.getBytes());
            if (attributesForTimestampToken != null) {
                SignerInformation signerInformation = (SignerInformation)cmsSignedDataTimeStampToken.getSignerInfos().getSigners().iterator().next();
                AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
                for (Attribute attributeToAdd : attributesForTimestampToken) {
                    ASN1ObjectIdentifier attrType = attributeToAdd.getAttrType();
                    ASN1Encodable objectAt = attributeToAdd.getAttrValues().getObjectAt(0);
                    unsignedAttributes = unsignedAttributes.add(attrType, objectAt);
                }
                if (unsignedAttributes.size() == 0) {
                    unsignedAttributes = null;
                }
                SignerInformation newSignerInformation = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
                ArrayList<SignerInformation> signerInformationList = new ArrayList<SignerInformation>();
                signerInformationList.add(newSignerInformation);
                SignerInformationStore newSignerStore = new SignerInformationStore(signerInformationList);
                cmsSignedDataTimeStampToken = CMSSignedData.replaceSigners((CMSSignedData)cmsSignedDataTimeStampToken, (SignerInformationStore)newSignerStore);
            }
            byte[] newTimeStampTokenBytes = cmsSignedDataTimeStampToken.getEncoded();
            return DSSASN1Utils.toASN1Primitive((byte[])newTimeStampTokenBytes);
        }
        catch (IOException | CMSException e) {
            throw new DSSException("Cannot obtain timestamp attribute value.", e);
        }
    }
}

